/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.entities;

import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.entities.IAggregate;
import com.bcxin.Infrastructures.enums.EmploymentStatus;
import java.sql.Timestamp;
import java.time.Instant;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

@Table(name="tenant_unique_data_constraints")
@Entity
public class UniqueDataConstraintEntity
extends EntityAbstract
implements IAggregate {
    @Id
    @Column(length=255)
    private String id;
    @Id
    @Column(length=255, nullable=false)
    private String category;
    private Timestamp createdTime = Timestamp.from(Instant.now());

    protected UniqueDataConstraintEntity() {
    }

    public static UniqueDataConstraintEntity create(String id, String category) {
        UniqueDataConstraintEntity data = new UniqueDataConstraintEntity();
        data.setId(id);
        data.setCategory(category);
        return data;
    }

    public static String generateId(String combineId) {
        return String.format("%s_%s", "PK_UNIQUE_DATA_", combineId);
    }

    public static String getNewEmployeeCombinedId(String tenantUserId) {
        return String.format("%s+%s", tenantUserId, EmploymentStatus.OnJob);
    }

    public String getId() {
        return this.id;
    }

    public String getCategory() {
        return this.category;
    }

    public Timestamp getCreatedTime() {
        return this.createdTime;
    }

    protected void setId(String id) {
        this.id = id;
    }

    protected void setCategory(String category) {
        this.category = category;
    }

    protected void setCreatedTime(Timestamp createdTime) {
        this.createdTime = createdTime;
    }
}

