package com.bcxin.api.interfaces.tenants.requests.employees;

import com.bcxin.Infrastructures.entities.OperatorValueType;
import com.bcxin.Infrastructures.enums.OccupationType;
import com.bcxin.Infrastructures.models.CredentialModel;
import com.bcxin.api.interfaces.RequestAbstract;
import lombok.Data;

import javax.persistence.Embedded;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.Date;

@Data
public class EmployeeRequest extends RequestAbstract {
    @NotEmpty
    private String name;

    @NotEmpty
    private String telephone;
    /**
     * 所属本部门
     */
    @NotEmpty
    private String departId;
    /**
     * 职业类型
     */
    @NotNull
    private OccupationType occupationType;
    /**
     * 岗位
     */
    private String position;
    /**
     * 入职时间
     */
    @NotNull
    private Date hiredDate;

    private CredentialModel credential;

    @Embedded
    private OperatorValueType operator;

    /**
     * 异常人员入职：2：需要校验并且仅提醒确定入职
     */
    private Boolean abnormalPersonnelConfirm;
}
