package com.bcxin.api.interfaces.tenants;

import com.bcxin.Infrastructures.Pageable;
import com.bcxin.Infrastructures.enums.InvitedType;
import com.bcxin.api.interfaces.identities.requests.InvitedToJoinQueuesRequest;
import com.bcxin.api.interfaces.tenants.criterias.InvitedToJoinQueuesCriteria;
import com.bcxin.api.interfaces.tenants.requests.employees.EmployeeRequest;
import com.bcxin.api.interfaces.tenants.responses.InvitedToJoinQueuesGetResponse;
import org.springframework.stereotype.Component;

@Component
public interface InvitedToJoinQueuesRpcProvider {

    void create(InvitedType invitedType,String inviteId, EmployeeRequest request);

    Pageable<InvitedToJoinQueuesGetResponse> find(String organizationId, InvitedToJoinQueuesCriteria criteria);

    void dispatch(String organizationId, InvitedToJoinQueuesRequest request);
}
