package com.bcxin.api.interfaces.rbacs.custom.response;

import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.serializer.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@ApiModel("职员已授权操作项返回对象")
@Data
public class RbacPermitOptionAuthResponse implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "操作项ID")
    @JSONField(serializeUsing = ToStringSerializer.class)
    private Long optionId;

    @ApiModelProperty(value = "操作项类型，1：web，2：app")
    private Integer optionType;

    @ApiModelProperty(value = "操作项代码/菜单id")
    private String optionCode;

    @ApiModelProperty(value = "操作项名称")
    private String optionName;

    @ApiModelProperty(value = "操作项分类")
    private String category;

}
