package com.bcxin.security.domains.entities;

import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.entities.IAggregate;
import com.bcxin.Infrastructures.enums.CredentialType;
import com.bcxin.Infrastructures.enums.OccupationType;
import com.bcxin.Infrastructures.utils.UUIDUtil;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.*;
import java.sql.Timestamp;
import java.time.Instant;

@Getter
@Setter
@Table(name = "tlk_attendance_site_person_info")
@Entity
public class AttendSitePersonEntity extends EntityAbstract implements IAggregate {

    @Id
    private String id;

    @Column(name = "ITEM_SECURITYNAME")
    private String securityName;

    @Column(name = "ITEM_SECURITYID")
    private String securityId;

    @Column(name = "ITEM_DOCUMENTTYPE")
    @Enumerated(EnumType.ORDINAL)
    private CredentialType documentType;

    @Column(name = "ITEM_DOCUMENTID")
    private String documentId;

    @Column(name = "ITEM_PHONE")
    private String phone;

    @Column(name = "ITEM_DEPTNAME")
    private String deptName;

    @Column(name = "ITEM_JOBTYPE")
    @Enumerated(EnumType.ORDINAL)
    private OccupationType jobType;

    @Column(name = "ITEM_ISCERTIFIED")
    private String isCertified;

    @Column(name = "ITEM_INSURANCESTATUS")
    private String insuranceStatus;

    @Column(name = "ITEM_CREATEDUSER")
    private String createdUser;

    @Column(name = "ITEM_ATTENDANCESITEID")
    private String attendanceSiteId;

    @Column(name = "DOMAINID")
    private String domainId;

    @Column(name = "ITEM_DOMAIN_ID")
    private String iDomainId;

    @Column(name = "AUTHOR")
    private String author;

    @Column(name = "AUTHORDEPTID")
    private String authorDeptId;

    @Column(name = "AUTHOR_DEPT_INDEX")
    private String authorDeptIndex;

    @Column(name = "LASTMODIFIER")
    private String lastModifier;

    @Column(name = "CREATED")
    private Timestamp created;

    @Column(name = "LASTMODIFIED")
    private Timestamp lastModified;

    @Column(name = "APPLICATIONID")
    private String applicationId;

    @Column(name = "FORMID")
    private String formId;

    @Column(name = "FORMNAME")
    private String formName;

    @Column(name = "ISTMP")
    private boolean isTmp = false;

    @Column(name = "STATEINT")
    private String stateint = "0";

    public AttendSitePersonEntity(){}

    public AttendSitePersonEntity(String securityName,
                                  String securityId,
                                  CredentialType documentType,
                                  String documentId,
                                  String phone,
                                  String deptName,
                                  OccupationType jobType,
                                  String isCertified,
                                  String insuranceStatus,
                                  String createdUser,
                                  String attendanceSiteId,
                                  String domainId,
                                  String author,
                                  String authorDeptId,
                                  String authorDeptIndex,
                                  String lastModifier,
                                  String applicationId,
                                  String formId,
                                  String formName
                                  ){
        this.securityName = securityName;
        this.securityId = securityId;
        this.documentType = documentType;
        this.documentId = documentId;
        this.phone = phone;
        this.deptName = deptName;
        this.jobType = jobType;
        this.isCertified = isCertified;
        this.insuranceStatus = insuranceStatus;
        this.createdUser = createdUser;
        this.attendanceSiteId = attendanceSiteId;
        this.domainId = domainId;
        this.iDomainId = domainId;
        this.author = author;
        this.authorDeptId = authorDeptId;
        this.authorDeptIndex = authorDeptIndex;
        this.lastModifier = lastModifier;
        this.applicationId = applicationId;
        this.formId = formId;
        this.formName = formName;

    }

    public static AttendSitePersonEntity create(String securityName,
                                                String securityId,
                                                CredentialType documentType,
                                                String documentId,
                                                String phone,
                                                String deptName,
                                                OccupationType jobType,
                                                String isCertified,
                                                String insuranceStatus,
                                                String createdUser,
                                                String attendanceSiteId,
                                                String domainId,
                                                String author,
                                                String authorDeptId,
                                                String authorDeptIndex,
                                                String lastModifier,
                                                String applicationId,
                                                String formId,
                                                String formName) {
        AttendSitePersonEntity attendSitePerson = new AttendSitePersonEntity(securityName,
                securityId,
                documentType,
                documentId,
                phone,
                deptName,
                jobType,
                isCertified,
                insuranceStatus,
                createdUser,
                attendanceSiteId,
                domainId,
                author,
                authorDeptId,
                authorDeptIndex,
                lastModifier,
                applicationId,
                formId,
                formName);
        attendSitePerson.setId(UUIDUtil.getShortUuid()+"--"+formId);
        attendSitePerson.setCreated(Timestamp.from(Instant.now()));
        attendSitePerson.setLastModified(Timestamp.from(Instant.now()));
        return attendSitePerson;
    }
}
