/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.infrastructures.utils;

import com.bcxin.tenant.open.infrastructures.enums.DeskType;
import com.bcxin.tenant.open.infrastructures.enums.DispatchAccountType;
import com.bcxin.tenant.open.infrastructures.exceptions.BadTenantException;
import com.bcxin.tenant.open.infrastructures.utils.StringUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class BusinessUtil {
    private static final Collection<String> securityAssiciationInstitutionals = Stream.of("0106", "0105", "0101").collect(Collectors.toList());

    public static boolean validReferenceNumber(String value) {
        if (StringUtil.isEmpty(value)) {
            return false;
        }
        return value.length() > 2;
    }

    public static boolean isSupervise(String institutional) {
        return BusinessUtil.isSecuritySupervise(institutional) || BusinessUtil.isProprietorSupervise(institutional) || BusinessUtil.isPopulationSupervise(institutional) || BusinessUtil.isOtherSupervise(institutional);
    }

    public static boolean isSecuritySupervise(String institutional) {
        if (StringUtil.isEmpty(institutional)) {
            return false;
        }
        Collection superviseInstitutionals = Stream.of("0107", "0108", "0109", "0110").collect(Collectors.toList());
        return superviseInstitutionals.stream().anyMatch(ii -> ii.equalsIgnoreCase(institutional));
    }

    public static boolean isProprietorSupervise(String institutional) {
        if (StringUtil.isEmpty(institutional)) {
            return false;
        }
        Collection superviseInstitutionals = Stream.of("0407", "0408", "0409", "0410").collect(Collectors.toList());
        return superviseInstitutionals.stream().anyMatch(ii -> ii.equalsIgnoreCase(institutional));
    }

    public static boolean isPopulationSupervise(String institutional) {
        if (StringUtil.isEmpty(institutional)) {
            return false;
        }
        Collection superviseInstitutionals = Stream.of("0607", "0608", "0609", "0610").collect(Collectors.toList());
        return superviseInstitutionals.stream().anyMatch(ii -> ii.equalsIgnoreCase(institutional));
    }

    public static boolean isOtherSupervise(String institutional) {
        if (StringUtil.isEmpty(institutional)) {
            return false;
        }
        if ((institutional = institutional.trim()).length() != 4) {
            return false;
        }
        return institutional.endsWith("07") || institutional.endsWith("08") || institutional.endsWith("09") || institutional.endsWith("10");
    }

    public static boolean isExpectedOrganization(String expectedOrgId, String orgId) {
        return StringUtil.isEmpty(orgId) || StringUtil.isEqual(expectedOrgId, orgId);
    }

    public static String[] getDefaultInstitutionals(Collection<DeskType> deskTypes) {
        if (deskTypes == null || deskTypes.isEmpty()) {
            throw new BadTenantException("\u8c03\u5ea6\u53f0\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HashSet<String> institutionals = new HashSet<String>();
        for (DeskType deskType : deskTypes) {
            if (deskType == DeskType.Proprietor) {
                institutionals.addAll(BusinessUtil.getProprietorInstitutional());
                continue;
            }
            institutionals.add("0102");
            institutionals.add("0103");
            institutionals.add("0104");
        }
        return (String[])institutionals.toArray(String[]::new);
    }

    public static String getInstitutionalName(String institutional) {
        if (StringUtil.isEmpty(institutional)) {
            return "";
        }
        switch (institutional) {
            case "0102": {
                return "\u4fdd\u5b89\u670d\u52a1\u516c\u53f8";
            }
            case "0103": {
                return "\u4fdd\u5b89\u57f9\u8bad\u5355\u4f4d";
            }
            case "0104": {
                return "\u81ea\u884c\u62db\u7528\u4fdd\u5b89\u5458\u5355\u4f4d";
            }
            case "0403": {
                return "\u4e2d\u5c0f\u5b66\u3001\u5e7c\u513f\u56ed";
            }
            case "0404": {
                return "\u9ad8\u6821";
            }
            case "0401": {
                return "\u533b\u7597\u5355\u4f4d";
            }
            case "0405": {
                return "\u91d1\u878d\u5355\u4f4d";
            }
            case "0402": {
                return "\u6587\u535a\u5355\u4f4d";
            }
            case "0406": {
                return "\u515a\u653f\u673a\u5173";
            }
            case "0201": {
                return "\u6d3b\u52a8\u627f\u529e\u5546";
            }
            case "0212": {
                return "\u7ec4\u59d4\u4f1a";
            }
            case "0214": {
                return "\u4f53\u80b2\u5c40";
            }
            case "0215": {
                return "\u6587\u65c5\u5c40";
            }
            case "0216": {
                return "\u536b\u5065\u59d4";
            }
            case "0217": {
                return "\u653f\u6cd5\u59d4";
            }
            case "0218": {
                return "\u5171\u9752\u56e2";
            }
            case "0219": {
                return "\u793e\u56e2\u5fd7\u613f\u8005\u56e2\u961f";
            }
            case "0221": {
                return "\u65e0\u4eba\u673a\u53cd\u5236\u516c\u53f8";
            }
        }
        return institutional;
    }

    public static boolean checkIfDynamicCountOfStationsAndMen(String institutional) {
        return BusinessUtil.getProprietorInstitutional().contains(institutional);
    }

    private static Collection<String> getProprietorInstitutional() {
        HashSet<String> institutional = new HashSet<String>();
        institutional.add("0403");
        institutional.add("0404");
        institutional.add("0401");
        institutional.add("0405");
        institutional.add("0402");
        institutional.add("0406");
        return institutional;
    }

    public static boolean isProprietor(String institutional) {
        if (StringUtil.isEmpty(institutional)) {
            return false;
        }
        return BusinessUtil.getProprietorInstitutional().stream().anyMatch(ii -> ii.equalsIgnoreCase(institutional));
    }

    public static boolean checkIfSecurityStationRelativeUsers(String institutional) {
        if (StringUtil.isEmpty(institutional)) {
            return false;
        }
        return (institutional = institutional.trim()).startsWith("01") || BusinessUtil.checkIfCommunityPolicing(institutional);
    }

    public static boolean checkIfCommunityPolicing(String institutional) {
        if (StringUtil.isEmpty(institutional)) {
            return false;
        }
        institutional = institutional.trim();
        return "0601".equalsIgnoreCase(institutional);
    }

    public static String getRollCallGeTuiTitle(String orgName) {
        return orgName;
    }

    public static String getRollCallGeTuiContent(String callerName) {
        return String.format("%s\u6b63\u5411\u60a8\u53d1\u8d77\u70b9\u540d\u8f6e\u8be2, \u8bf7\u63a5\u542c..", callerName);
    }

    public static boolean isStationResponsible(String responsibleOfStationId) {
        return !StringUtil.isEmpty(responsibleOfStationId) && !"#1".equalsIgnoreCase(responsibleOfStationId);
    }

    public static boolean checkIfDesk(DispatchAccountType accountType) {
        return accountType == DispatchAccountType.AppDesk || accountType == DispatchAccountType.Desk;
    }

    public static boolean isEventOrganizer(String institutional) {
        return BusinessUtil.isDaHuoManagedOrg(institutional) || "0102".equalsIgnoreCase(institutional);
    }

    public static boolean isSecurityAssociation(String institutional) {
        return securityAssiciationInstitutionals.stream().anyMatch(ii -> ii.equalsIgnoreCase(institutional));
    }

    public static boolean isEventSponsor(String institutional) {
        return "0201".equalsIgnoreCase(institutional);
    }

    public static boolean isOrgMember(String id) {
        return !StringUtil.isEmpty(id) && id.startsWith("1$");
    }

    public static String extractMemberId(String id) {
        return StringUtil.isEmpty(id) ? "" : id.substring(2);
    }

    public static boolean isDaHuoManagedOrg(String institutional) {
        return BusinessUtil.daHuoManagedOrgInstitutionals().contains(institutional);
    }

    public static Set<String> daHuoManagedOrgInstitutionals() {
        return Stream.of("0201", "0203", "0211", "0212", "0214", "0215", "0216", "0217", "0218", "0219", "0221").collect(Collectors.toSet());
    }

    public static boolean isEventProject(String id) {
        return !StringUtil.isEmpty(id) && id.endsWith("--__zNNa8cuUuYsO64cQ2u2");
    }

    public static Collection<String> getSplitValues(String input) {
        if (StringUtil.isEmpty(input)) {
            return Collections.EMPTY_LIST;
        }
        return Arrays.stream(input.split(";|,")).collect(Collectors.toSet());
    }

    public static String getPaymentOrgId(String orgId, String paymentOrgId) {
        if (!StringUtil.isEmpty(paymentOrgId) && !"#1".equalsIgnoreCase(paymentOrgId)) {
            return paymentOrgId;
        }
        return orgId;
    }
}

