/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.document.domains.components;

import com.bcxin.tenant.open.document.domains.components.SearchSpecialPermissionScopeComponent;
import com.bcxin.tenant.open.document.domains.documents.RdDispatchDataScopeDocument;
import com.bcxin.tenant.open.document.domains.documents.RdDispatchDataScopeDocument$;
import com.bcxin.tenant.open.document.domains.dtos.SearchSpecialPermissionScopeDTO;
import com.bcxin.tenant.open.infrastructures.TenantEmployeeContext;
import com.bcxin.tenant.open.infrastructures.utils.BusinessUtil;
import com.redis.om.spring.search.stream.EntityStream;
import com.redis.om.spring.search.stream.SearchStream;
import com.redis.om.spring.search.stream.predicates.SearchFieldPredicate;
import java.util.Collection;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class SearchSpecialPermissionScopeComponentImpl
implements SearchSpecialPermissionScopeComponent {
    private final EntityStream entityStream;

    public SearchSpecialPermissionScopeComponentImpl(EntityStream entityStream) {
        this.entityStream = entityStream;
    }

    @Override
    public SearchSpecialPermissionScopeDTO get(TenantEmployeeContext.TenantUserModel userModel) {
        if (!BusinessUtil.isProprietor((String)userModel.getOrgInstitutional())) {
            return SearchSpecialPermissionScopeDTO.createEmpty();
        }
        SearchStream scopeDocumentSearchStream = this.entityStream.of(RdDispatchDataScopeDocument.class);
        scopeDocumentSearchStream = scopeDocumentSearchStream.filter((SearchFieldPredicate)RdDispatchDataScopeDocument$.SCOPES.in(new String[]{userModel.getOrganizationId()}));
        Collection documents = (Collection)scopeDocumentSearchStream.collect(Collectors.toList());
        Collection scopeIds = documents.stream().map(ii -> ii.getId()).distinct().collect(Collectors.toList());
        return SearchSpecialPermissionScopeDTO.create(true, scopeIds);
    }
}

