/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.jdks.responses;

import com.bcxin.tenant.open.infrastructures.ResponseAbstract;
import com.bcxin.tenant.open.infrastructures.valueTypes.GeoLocationValueType;
import com.bcxin.tenant.open.jdks.requests.CompanySearchRequest;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Set;

@Schema(name="CompanySearchResponse", title="CompanySearchResponse \u516c\u53f8\u4fe1\u606f\u641c\u7d22\u7ed3\u679c")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CompanySearchResponse
extends ResponseAbstract {
    @Schema(name="id", title="\u4f01\u4e1aid")
    private final String id;
    @Schema(name="name", title="\u4f01\u4e1a\u540d\u79f0")
    private final String name;
    @Schema(name="legal", title="\u6cd5\u4eba\u59d3\u540d")
    private final String legal;
    @Schema(name="legalContact", title="\u6cd5\u4eba\u8054\u7cfb\u65b9\u5f0f")
    private final String legalContact;
    @Schema(name="registerAddress", title="\u6ce8\u518c\u5730")
    private final String registerAddress;
    @Schema(name="businessAddress", title="\u7ecf\u8425\u5730")
    private final String businessAddress;
    @Schema(name="latitude", title="\u4f01\u4e1a\u6240\u5728y\u8f74\u5750\u6807")
    private final Double latitude;
    @Schema(name="longitude", title="\u4f01\u4e1a\u6240\u5728x\u8f74\u5750\u6807")
    private final Double longitude;
    @Schema(name="countOfTemporaryProject", title="\u4e34\u4fdd\u9879\u76ee\u6570\u91cf")
    private final long countOfTemporaryProject;
    private final Set<String> followedDeviceNos;
    @Schema(name="isFollowed", title="\u662f\u5426\u5173\u6ce8")
    private final Boolean followed;

    public CompanySearchResponse(CompanySearchRequest.SearchModel searchModel, String id, String name, String legal, String legalContact, String registerAddress, String businessAddress, Double latitude, Double longitude, Set<String> followedDeviceNos, Boolean followed, long countOfTemporaryProject) {
        this.id = id;
        if (GeoLocationValueType.isValidLocation((Double)latitude, (Double)longitude)) {
            this.latitude = latitude;
            this.longitude = longitude;
        } else {
            this.latitude = null;
            this.longitude = null;
        }
        if (searchModel == CompanySearchRequest.SearchModel.SecurityResource) {
            this.name = null;
            this.legal = null;
            this.legalContact = null;
            this.registerAddress = null;
            this.businessAddress = null;
        } else {
            this.name = name;
            this.legal = legal;
            this.legalContact = legalContact;
            this.registerAddress = registerAddress;
            this.businessAddress = businessAddress;
        }
        this.followedDeviceNos = followedDeviceNos;
        this.followed = followed;
        this.countOfTemporaryProject = countOfTemporaryProject;
    }

    public static CompanySearchResponse create(CompanySearchRequest.SearchModel searchModel, String id, String name, String legal, String legalContact, String registerAddress, String businessAddress, Double latitude, Double longitude, Set<String> followedDeviceNos, Boolean followed, long countOfTemporaryProject) {
        return new CompanySearchResponse(searchModel, id, name, legal, legalContact, registerAddress, businessAddress, latitude, longitude, followedDeviceNos, followed, countOfTemporaryProject);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getLegal() {
        return this.legal;
    }

    public String getLegalContact() {
        return this.legalContact;
    }

    public String getRegisterAddress() {
        return this.registerAddress;
    }

    public String getBusinessAddress() {
        return this.businessAddress;
    }

    public Double getLatitude() {
        return this.latitude;
    }

    public Double getLongitude() {
        return this.longitude;
    }

    public long getCountOfTemporaryProject() {
        return this.countOfTemporaryProject;
    }

    public Set<String> getFollowedDeviceNos() {
        return this.followedDeviceNos;
    }

    public Boolean getFollowed() {
        return this.followed;
    }
}

