/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.domains.entities;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.tenant.open.infrastructures.entities.Aggregate;
import com.bcxin.tenant.open.infrastructures.entities.EntityAbstract;
import com.bcxin.tenant.open.infrastructures.enums.ContentFollowType;
import java.sql.Timestamp;
import java.time.Instant;
import org.apache.ibatis.type.EnumOrdinalTypeHandler;
import org.apache.ibatis.type.JdbcType;

@TableName(value="tenant_content_follows", autoResultMap=true)
public class TenantContentFollowEntity
extends EntityAbstract
implements Aggregate {
    @TableField(value="id")
    private Long id;
    @TableField(value="follow_type", jdbcType=JdbcType.TINYINT, javaType=true, typeHandler=EnumOrdinalTypeHandler.class)
    private ContentFollowType followType;
    @TableField(value="content_follow_id")
    private String contentFollowId;
    @TableField(value="is_followed")
    private boolean followed;
    @TableField(value="followed_time")
    private Timestamp followedTime;
    @TableField(value="unfollowed_time")
    private Timestamp unfollowedTime;
    @TableField(value="device_no")
    private String deviceNo;
    @TableField(value="follow_user_id")
    private String followUserId;
    @TableField(value="unfollow_user_id")
    private String unfollowUserId;
    @TableField(value="created_time")
    private Timestamp createdTime;

    public TenantContentFollowEntity() {
        Timestamp now = Timestamp.from(Instant.now());
        this.setCreatedTime(now);
    }

    public void markFollowed(String deviceNo, String userId) {
        this.setFollowed(true);
        this.setFollowedTime(Timestamp.from(Instant.now()));
        this.setDeviceNo(deviceNo);
        this.setFollowUserId(userId);
    }

    public void markUnfollowed(String userId) {
        this.setFollowed(false);
        this.setUnfollowUserId(userId);
    }

    public static TenantContentFollowEntity create(Long id, ContentFollowType followType, String contentFollowId, String deviceNo, String followUserId) {
        TenantContentFollowEntity contentFollow = new TenantContentFollowEntity();
        contentFollow.setId(id);
        contentFollow.setFollowType(followType);
        contentFollow.setContentFollowId(contentFollowId);
        contentFollow.markFollowed(deviceNo, followUserId);
        return contentFollow;
    }

    public Long getId() {
        return this.id;
    }

    public ContentFollowType getFollowType() {
        return this.followType;
    }

    public String getContentFollowId() {
        return this.contentFollowId;
    }

    public boolean isFollowed() {
        return this.followed;
    }

    public Timestamp getFollowedTime() {
        return this.followedTime;
    }

    public Timestamp getUnfollowedTime() {
        return this.unfollowedTime;
    }

    public String getDeviceNo() {
        return this.deviceNo;
    }

    public String getFollowUserId() {
        return this.followUserId;
    }

    public String getUnfollowUserId() {
        return this.unfollowUserId;
    }

    public Timestamp getCreatedTime() {
        return this.createdTime;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setFollowType(ContentFollowType followType) {
        this.followType = followType;
    }

    public void setContentFollowId(String contentFollowId) {
        this.contentFollowId = contentFollowId;
    }

    public void setFollowed(boolean followed) {
        this.followed = followed;
    }

    public void setFollowedTime(Timestamp followedTime) {
        this.followedTime = followedTime;
    }

    public void setUnfollowedTime(Timestamp unfollowedTime) {
        this.unfollowedTime = unfollowedTime;
    }

    public void setDeviceNo(String deviceNo) {
        this.deviceNo = deviceNo;
    }

    public void setFollowUserId(String followUserId) {
        this.followUserId = followUserId;
    }

    public void setUnfollowUserId(String unfollowUserId) {
        this.unfollowUserId = unfollowUserId;
    }

    public void setCreatedTime(Timestamp createdTime) {
        this.createdTime = createdTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TenantContentFollowEntity)) {
            return false;
        }
        TenantContentFollowEntity other = (TenantContentFollowEntity)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isFollowed() != other.isFollowed()) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        ContentFollowType this$followType = this.getFollowType();
        ContentFollowType other$followType = other.getFollowType();
        if (this$followType == null ? other$followType != null : !this$followType.equals(other$followType)) {
            return false;
        }
        String this$contentFollowId = this.getContentFollowId();
        String other$contentFollowId = other.getContentFollowId();
        if (this$contentFollowId == null ? other$contentFollowId != null : !this$contentFollowId.equals(other$contentFollowId)) {
            return false;
        }
        Timestamp this$followedTime = this.getFollowedTime();
        Timestamp other$followedTime = other.getFollowedTime();
        if (this$followedTime == null ? other$followedTime != null : !((Object)this$followedTime).equals(other$followedTime)) {
            return false;
        }
        Timestamp this$unfollowedTime = this.getUnfollowedTime();
        Timestamp other$unfollowedTime = other.getUnfollowedTime();
        if (this$unfollowedTime == null ? other$unfollowedTime != null : !((Object)this$unfollowedTime).equals(other$unfollowedTime)) {
            return false;
        }
        String this$deviceNo = this.getDeviceNo();
        String other$deviceNo = other.getDeviceNo();
        if (this$deviceNo == null ? other$deviceNo != null : !this$deviceNo.equals(other$deviceNo)) {
            return false;
        }
        String this$followUserId = this.getFollowUserId();
        String other$followUserId = other.getFollowUserId();
        if (this$followUserId == null ? other$followUserId != null : !this$followUserId.equals(other$followUserId)) {
            return false;
        }
        String this$unfollowUserId = this.getUnfollowUserId();
        String other$unfollowUserId = other.getUnfollowUserId();
        if (this$unfollowUserId == null ? other$unfollowUserId != null : !this$unfollowUserId.equals(other$unfollowUserId)) {
            return false;
        }
        Timestamp this$createdTime = this.getCreatedTime();
        Timestamp other$createdTime = other.getCreatedTime();
        return !(this$createdTime == null ? other$createdTime != null : !((Object)this$createdTime).equals(other$createdTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TenantContentFollowEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isFollowed() ? 79 : 97);
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        ContentFollowType $followType = this.getFollowType();
        result = result * 59 + ($followType == null ? 43 : $followType.hashCode());
        String $contentFollowId = this.getContentFollowId();
        result = result * 59 + ($contentFollowId == null ? 43 : $contentFollowId.hashCode());
        Timestamp $followedTime = this.getFollowedTime();
        result = result * 59 + ($followedTime == null ? 43 : ((Object)$followedTime).hashCode());
        Timestamp $unfollowedTime = this.getUnfollowedTime();
        result = result * 59 + ($unfollowedTime == null ? 43 : ((Object)$unfollowedTime).hashCode());
        String $deviceNo = this.getDeviceNo();
        result = result * 59 + ($deviceNo == null ? 43 : $deviceNo.hashCode());
        String $followUserId = this.getFollowUserId();
        result = result * 59 + ($followUserId == null ? 43 : $followUserId.hashCode());
        String $unfollowUserId = this.getUnfollowUserId();
        result = result * 59 + ($unfollowUserId == null ? 43 : $unfollowUserId.hashCode());
        Timestamp $createdTime = this.getCreatedTime();
        result = result * 59 + ($createdTime == null ? 43 : ((Object)$createdTime).hashCode());
        return result;
    }

    public String toString() {
        return "TenantContentFollowEntity(id=" + this.getId() + ", followType=" + this.getFollowType() + ", contentFollowId=" + this.getContentFollowId() + ", followed=" + this.isFollowed() + ", followedTime=" + this.getFollowedTime() + ", unfollowedTime=" + this.getUnfollowedTime() + ", deviceNo=" + this.getDeviceNo() + ", followUserId=" + this.getFollowUserId() + ", unfollowUserId=" + this.getUnfollowUserId() + ", createdTime=" + this.getCreatedTime() + ")";
    }
}

