/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.document.domains.documents;

import com.bcxin.tenant.open.infrastructures.entities.Aggregate;
import com.bcxin.tenant.open.infrastructures.entities.EntityAbstract;
import com.bcxin.tenant.open.infrastructures.enums.ContentFollowType;
import com.redis.om.spring.annotations.Document;
import com.redis.om.spring.annotations.Indexed;
import com.redis.om.spring.repository.query.SearchLanguage;
import org.springframework.data.annotation.Id;

@Document(language=SearchLanguage.CHINESE)
public class TenantContentFollowDocument
extends EntityAbstract
implements Aggregate {
    @Id
    @Indexed
    private String businessId;
    private Long id;
    @Indexed
    private String followType;
    @Indexed
    private String contentFollowId;
    @Indexed
    private String followerId;

    public static TenantContentFollowDocument create(String businessId, ContentFollowType followType, String contentFollowId, String followerId) {
        TenantContentFollowDocument document = new TenantContentFollowDocument();
        document.setBusinessId(businessId);
        document.setFollowType(followType.name());
        document.setContentFollowId(contentFollowId);
        document.setFollowerId(followerId);
        return document;
    }

    public String getBusinessId() {
        return this.businessId;
    }

    public Long getId() {
        return this.id;
    }

    public String getFollowType() {
        return this.followType;
    }

    public String getContentFollowId() {
        return this.contentFollowId;
    }

    public String getFollowerId() {
        return this.followerId;
    }

    public void setBusinessId(String businessId) {
        this.businessId = businessId;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setFollowType(String followType) {
        this.followType = followType;
    }

    public void setContentFollowId(String contentFollowId) {
        this.contentFollowId = contentFollowId;
    }

    public void setFollowerId(String followerId) {
        this.followerId = followerId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TenantContentFollowDocument)) {
            return false;
        }
        TenantContentFollowDocument other = (TenantContentFollowDocument)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$businessId = this.getBusinessId();
        String other$businessId = other.getBusinessId();
        if (this$businessId == null ? other$businessId != null : !this$businessId.equals(other$businessId)) {
            return false;
        }
        String this$followType = this.getFollowType();
        String other$followType = other.getFollowType();
        if (this$followType == null ? other$followType != null : !this$followType.equals(other$followType)) {
            return false;
        }
        String this$contentFollowId = this.getContentFollowId();
        String other$contentFollowId = other.getContentFollowId();
        if (this$contentFollowId == null ? other$contentFollowId != null : !this$contentFollowId.equals(other$contentFollowId)) {
            return false;
        }
        String this$followerId = this.getFollowerId();
        String other$followerId = other.getFollowerId();
        return !(this$followerId == null ? other$followerId != null : !this$followerId.equals(other$followerId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TenantContentFollowDocument;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $businessId = this.getBusinessId();
        result = result * 59 + ($businessId == null ? 43 : $businessId.hashCode());
        String $followType = this.getFollowType();
        result = result * 59 + ($followType == null ? 43 : $followType.hashCode());
        String $contentFollowId = this.getContentFollowId();
        result = result * 59 + ($contentFollowId == null ? 43 : $contentFollowId.hashCode());
        String $followerId = this.getFollowerId();
        result = result * 59 + ($followerId == null ? 43 : $followerId.hashCode());
        return result;
    }

    public String toString() {
        return "TenantContentFollowDocument(businessId=" + this.getBusinessId() + ", id=" + this.getId() + ", followType=" + this.getFollowType() + ", contentFollowId=" + this.getContentFollowId() + ", followerId=" + this.getFollowerId() + ")";
    }
}

