/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.document.domains.documents;

import com.bcxin.tenant.open.infrastructures.entities.EntityAbstract;
import com.bcxin.tenant.open.infrastructures.enums.DispatchDataScopeType;
import com.redis.om.spring.annotations.Document;
import com.redis.om.spring.annotations.Indexed;
import com.redis.om.spring.repository.query.SearchLanguage;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.data.annotation.Id;
import org.springframework.util.StringUtils;

@Document(language=SearchLanguage.CHINESE)
public class RdDispatchDataScopeDocument
extends EntityAbstract {
    @Id
    @Indexed
    private String id;
    @Indexed
    private Set<String> scopes;
    private DispatchDataScopeType scopeType;

    public void assignScopes(String ... scopes) {
        if (scopes == null || scopes.length == 0) {
            this.setScopes(new HashSet<String>());
        } else {
            this.setScopes(Arrays.stream(scopes).filter(ii -> StringUtils.hasLength((String)ii)).collect(Collectors.toSet()));
        }
    }

    public static RdDispatchDataScopeDocument create(String id, DispatchDataScopeType scopeType) {
        RdDispatchDataScopeDocument document = new RdDispatchDataScopeDocument();
        document.setId(id);
        document.setScopeType(scopeType);
        return document;
    }

    public String getId() {
        return this.id;
    }

    public Set<String> getScopes() {
        return this.scopes;
    }

    public DispatchDataScopeType getScopeType() {
        return this.scopeType;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setScopes(Set<String> scopes) {
        this.scopes = scopes;
    }

    public void setScopeType(DispatchDataScopeType scopeType) {
        this.scopeType = scopeType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RdDispatchDataScopeDocument)) {
            return false;
        }
        RdDispatchDataScopeDocument other = (RdDispatchDataScopeDocument)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Set<String> this$scopes = this.getScopes();
        Set<String> other$scopes = other.getScopes();
        if (this$scopes == null ? other$scopes != null : !((Object)this$scopes).equals(other$scopes)) {
            return false;
        }
        DispatchDataScopeType this$scopeType = this.getScopeType();
        DispatchDataScopeType other$scopeType = other.getScopeType();
        return !(this$scopeType == null ? other$scopeType != null : !this$scopeType.equals(other$scopeType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RdDispatchDataScopeDocument;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Set<String> $scopes = this.getScopes();
        result = result * 59 + ($scopes == null ? 43 : ((Object)$scopes).hashCode());
        DispatchDataScopeType $scopeType = this.getScopeType();
        result = result * 59 + ($scopeType == null ? 43 : $scopeType.hashCode());
        return result;
    }

    public String toString() {
        return "RdDispatchDataScopeDocument(id=" + this.getId() + ", scopes=" + this.getScopes() + ", scopeType=" + this.getScopeType() + ")";
    }
}

