/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.document.domains.documents;

import com.bcxin.tenant.open.infrastructures.entities.EntityAbstract;
import com.bcxin.tenant.open.infrastructures.enums.CompanyStatus;
import com.bcxin.tenant.open.infrastructures.utils.SetUtil;
import com.redis.om.spring.annotations.Document;
import com.redis.om.spring.annotations.GeoIndexed;
import com.redis.om.spring.annotations.Indexed;
import com.redis.om.spring.annotations.Searchable;
import com.redis.om.spring.annotations.TagIndexed;
import com.redis.om.spring.repository.query.SearchLanguage;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.data.annotation.Id;
import org.springframework.data.geo.Point;
import org.springframework.util.StringUtils;

@Document(language=SearchLanguage.CHINESE)
public class RdCompanyDocument
extends EntityAbstract {
    @Indexed
    private String id;
    @Indexed
    private String name;
    @Searchable(sortable=false, nostem=true, weight=20.0)
    private String keyword;
    private String legal;
    private String legalTelephone;
    @Indexed
    private String institutional;
    @Indexed
    private String registerAddress;
    @Indexed
    private String businessAddress;
    private Long countOfActivityStation;
    private Long countOfSecurityMan;
    private Long countOfMan;
    private String serviceScope;
    @Indexed
    @GeoIndexed
    private Point lonLat;
    @Id
    @Indexed
    private String organizationId;
    @Indexed
    private Long points;
    @Indexed
    private int countOfDesk;
    private long countOfTemporaryProject;
    private CompanyStatus status;
    private Timestamp lastUpdatedTime;
    @Indexed
    private String superviseDepartId;
    private String superviseDepartName;
    private String industry;
    @Indexed
    private int hasLonLatFlag;
    @Indexed
    private Set<String> scopePermissions;
    @Indexed
    private Set<String> resourceTypes;
    @Indexed
    @TagIndexed
    private Set<String> followedDeviceNos;
    private String superviseRegionCode;

    public RdCompanyDocument() {
        this.setLastUpdatedTime(Timestamp.from(Instant.now()));
    }

    public void addScopePermissions(String ... scopeIds) {
        this.setScopePermissions(SetUtil.merge(this.getScopePermissions(), (Object[])scopeIds));
    }

    public void addResourceTypes(String ... resourceTypes) {
        this.setResourceTypes(SetUtil.merge(this.getResourceTypes(), (Object[])resourceTypes));
    }

    public boolean addFollowedDeviceNo(String deviceNo) {
        this.setFollowedDeviceNos(SetUtil.merge(this.getFollowedDeviceNos(), (Object[])new String[]{deviceNo}));
        return true;
    }

    public boolean removeFollowedDeviceNo(String deviceNo) {
        this.setFollowedDeviceNos(SetUtil.remove(this.getFollowedDeviceNos(), (Object[])new String[]{deviceNo}));
        return true;
    }

    public void updateWord(String ... text) {
        if (text == null || text.length == 0) {
            this.setKeyword("");
        }
        String content = Arrays.stream(text).filter(ii -> StringUtils.hasLength((String)ii)).collect(Collectors.joining(" "));
        this.setKeyword(content);
    }

    public void rest() {
        this.setSuperviseDepartId("#1");
        this.setScopePermissions(new HashSet<String>());
        this.setResourceTypes(new HashSet<String>());
    }

    public void updateCountOfProject(long count) {
        this.setCountOfTemporaryProject(count);
        this.setLastUpdatedTime(Timestamp.from(Instant.now()));
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public String getLegal() {
        return this.legal;
    }

    public String getLegalTelephone() {
        return this.legalTelephone;
    }

    public String getInstitutional() {
        return this.institutional;
    }

    public String getRegisterAddress() {
        return this.registerAddress;
    }

    public String getBusinessAddress() {
        return this.businessAddress;
    }

    public Long getCountOfActivityStation() {
        return this.countOfActivityStation;
    }

    public Long getCountOfSecurityMan() {
        return this.countOfSecurityMan;
    }

    public Long getCountOfMan() {
        return this.countOfMan;
    }

    public String getServiceScope() {
        return this.serviceScope;
    }

    public Point getLonLat() {
        return this.lonLat;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public Long getPoints() {
        return this.points;
    }

    public int getCountOfDesk() {
        return this.countOfDesk;
    }

    public long getCountOfTemporaryProject() {
        return this.countOfTemporaryProject;
    }

    public CompanyStatus getStatus() {
        return this.status;
    }

    public Timestamp getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public String getSuperviseDepartId() {
        return this.superviseDepartId;
    }

    public String getSuperviseDepartName() {
        return this.superviseDepartName;
    }

    public String getIndustry() {
        return this.industry;
    }

    public int getHasLonLatFlag() {
        return this.hasLonLatFlag;
    }

    public Set<String> getScopePermissions() {
        return this.scopePermissions;
    }

    public Set<String> getResourceTypes() {
        return this.resourceTypes;
    }

    public Set<String> getFollowedDeviceNos() {
        return this.followedDeviceNos;
    }

    public String getSuperviseRegionCode() {
        return this.superviseRegionCode;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public void setLegal(String legal) {
        this.legal = legal;
    }

    public void setLegalTelephone(String legalTelephone) {
        this.legalTelephone = legalTelephone;
    }

    public void setInstitutional(String institutional) {
        this.institutional = institutional;
    }

    public void setRegisterAddress(String registerAddress) {
        this.registerAddress = registerAddress;
    }

    public void setBusinessAddress(String businessAddress) {
        this.businessAddress = businessAddress;
    }

    public void setCountOfActivityStation(Long countOfActivityStation) {
        this.countOfActivityStation = countOfActivityStation;
    }

    public void setCountOfSecurityMan(Long countOfSecurityMan) {
        this.countOfSecurityMan = countOfSecurityMan;
    }

    public void setCountOfMan(Long countOfMan) {
        this.countOfMan = countOfMan;
    }

    public void setServiceScope(String serviceScope) {
        this.serviceScope = serviceScope;
    }

    public void setLonLat(Point lonLat) {
        this.lonLat = lonLat;
    }

    public void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }

    public void setPoints(Long points) {
        this.points = points;
    }

    public void setCountOfDesk(int countOfDesk) {
        this.countOfDesk = countOfDesk;
    }

    public void setCountOfTemporaryProject(long countOfTemporaryProject) {
        this.countOfTemporaryProject = countOfTemporaryProject;
    }

    public void setStatus(CompanyStatus status) {
        this.status = status;
    }

    public void setLastUpdatedTime(Timestamp lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
    }

    public void setSuperviseDepartId(String superviseDepartId) {
        this.superviseDepartId = superviseDepartId;
    }

    public void setSuperviseDepartName(String superviseDepartName) {
        this.superviseDepartName = superviseDepartName;
    }

    public void setIndustry(String industry) {
        this.industry = industry;
    }

    public void setHasLonLatFlag(int hasLonLatFlag) {
        this.hasLonLatFlag = hasLonLatFlag;
    }

    public void setScopePermissions(Set<String> scopePermissions) {
        this.scopePermissions = scopePermissions;
    }

    public void setResourceTypes(Set<String> resourceTypes) {
        this.resourceTypes = resourceTypes;
    }

    public void setFollowedDeviceNos(Set<String> followedDeviceNos) {
        this.followedDeviceNos = followedDeviceNos;
    }

    public void setSuperviseRegionCode(String superviseRegionCode) {
        this.superviseRegionCode = superviseRegionCode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RdCompanyDocument)) {
            return false;
        }
        RdCompanyDocument other = (RdCompanyDocument)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getCountOfDesk() != other.getCountOfDesk()) {
            return false;
        }
        if (this.getCountOfTemporaryProject() != other.getCountOfTemporaryProject()) {
            return false;
        }
        if (this.getHasLonLatFlag() != other.getHasLonLatFlag()) {
            return false;
        }
        Long this$countOfActivityStation = this.getCountOfActivityStation();
        Long other$countOfActivityStation = other.getCountOfActivityStation();
        if (this$countOfActivityStation == null ? other$countOfActivityStation != null : !((Object)this$countOfActivityStation).equals(other$countOfActivityStation)) {
            return false;
        }
        Long this$countOfSecurityMan = this.getCountOfSecurityMan();
        Long other$countOfSecurityMan = other.getCountOfSecurityMan();
        if (this$countOfSecurityMan == null ? other$countOfSecurityMan != null : !((Object)this$countOfSecurityMan).equals(other$countOfSecurityMan)) {
            return false;
        }
        Long this$countOfMan = this.getCountOfMan();
        Long other$countOfMan = other.getCountOfMan();
        if (this$countOfMan == null ? other$countOfMan != null : !((Object)this$countOfMan).equals(other$countOfMan)) {
            return false;
        }
        Long this$points = this.getPoints();
        Long other$points = other.getPoints();
        if (this$points == null ? other$points != null : !((Object)this$points).equals(other$points)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$keyword = this.getKeyword();
        String other$keyword = other.getKeyword();
        if (this$keyword == null ? other$keyword != null : !this$keyword.equals(other$keyword)) {
            return false;
        }
        String this$legal = this.getLegal();
        String other$legal = other.getLegal();
        if (this$legal == null ? other$legal != null : !this$legal.equals(other$legal)) {
            return false;
        }
        String this$legalTelephone = this.getLegalTelephone();
        String other$legalTelephone = other.getLegalTelephone();
        if (this$legalTelephone == null ? other$legalTelephone != null : !this$legalTelephone.equals(other$legalTelephone)) {
            return false;
        }
        String this$institutional = this.getInstitutional();
        String other$institutional = other.getInstitutional();
        if (this$institutional == null ? other$institutional != null : !this$institutional.equals(other$institutional)) {
            return false;
        }
        String this$registerAddress = this.getRegisterAddress();
        String other$registerAddress = other.getRegisterAddress();
        if (this$registerAddress == null ? other$registerAddress != null : !this$registerAddress.equals(other$registerAddress)) {
            return false;
        }
        String this$businessAddress = this.getBusinessAddress();
        String other$businessAddress = other.getBusinessAddress();
        if (this$businessAddress == null ? other$businessAddress != null : !this$businessAddress.equals(other$businessAddress)) {
            return false;
        }
        String this$serviceScope = this.getServiceScope();
        String other$serviceScope = other.getServiceScope();
        if (this$serviceScope == null ? other$serviceScope != null : !this$serviceScope.equals(other$serviceScope)) {
            return false;
        }
        Point this$lonLat = this.getLonLat();
        Point other$lonLat = other.getLonLat();
        if (this$lonLat == null ? other$lonLat != null : !this$lonLat.equals(other$lonLat)) {
            return false;
        }
        String this$organizationId = this.getOrganizationId();
        String other$organizationId = other.getOrganizationId();
        if (this$organizationId == null ? other$organizationId != null : !this$organizationId.equals(other$organizationId)) {
            return false;
        }
        CompanyStatus this$status = this.getStatus();
        CompanyStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        Timestamp this$lastUpdatedTime = this.getLastUpdatedTime();
        Timestamp other$lastUpdatedTime = other.getLastUpdatedTime();
        if (this$lastUpdatedTime == null ? other$lastUpdatedTime != null : !((Object)this$lastUpdatedTime).equals(other$lastUpdatedTime)) {
            return false;
        }
        String this$superviseDepartId = this.getSuperviseDepartId();
        String other$superviseDepartId = other.getSuperviseDepartId();
        if (this$superviseDepartId == null ? other$superviseDepartId != null : !this$superviseDepartId.equals(other$superviseDepartId)) {
            return false;
        }
        String this$superviseDepartName = this.getSuperviseDepartName();
        String other$superviseDepartName = other.getSuperviseDepartName();
        if (this$superviseDepartName == null ? other$superviseDepartName != null : !this$superviseDepartName.equals(other$superviseDepartName)) {
            return false;
        }
        String this$industry = this.getIndustry();
        String other$industry = other.getIndustry();
        if (this$industry == null ? other$industry != null : !this$industry.equals(other$industry)) {
            return false;
        }
        Set<String> this$scopePermissions = this.getScopePermissions();
        Set<String> other$scopePermissions = other.getScopePermissions();
        if (this$scopePermissions == null ? other$scopePermissions != null : !((Object)this$scopePermissions).equals(other$scopePermissions)) {
            return false;
        }
        Set<String> this$resourceTypes = this.getResourceTypes();
        Set<String> other$resourceTypes = other.getResourceTypes();
        if (this$resourceTypes == null ? other$resourceTypes != null : !((Object)this$resourceTypes).equals(other$resourceTypes)) {
            return false;
        }
        Set<String> this$followedDeviceNos = this.getFollowedDeviceNos();
        Set<String> other$followedDeviceNos = other.getFollowedDeviceNos();
        if (this$followedDeviceNos == null ? other$followedDeviceNos != null : !((Object)this$followedDeviceNos).equals(other$followedDeviceNos)) {
            return false;
        }
        String this$superviseRegionCode = this.getSuperviseRegionCode();
        String other$superviseRegionCode = other.getSuperviseRegionCode();
        return !(this$superviseRegionCode == null ? other$superviseRegionCode != null : !this$superviseRegionCode.equals(other$superviseRegionCode));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RdCompanyDocument;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCountOfDesk();
        long $countOfTemporaryProject = this.getCountOfTemporaryProject();
        result = result * 59 + (int)($countOfTemporaryProject >>> 32 ^ $countOfTemporaryProject);
        result = result * 59 + this.getHasLonLatFlag();
        Long $countOfActivityStation = this.getCountOfActivityStation();
        result = result * 59 + ($countOfActivityStation == null ? 43 : ((Object)$countOfActivityStation).hashCode());
        Long $countOfSecurityMan = this.getCountOfSecurityMan();
        result = result * 59 + ($countOfSecurityMan == null ? 43 : ((Object)$countOfSecurityMan).hashCode());
        Long $countOfMan = this.getCountOfMan();
        result = result * 59 + ($countOfMan == null ? 43 : ((Object)$countOfMan).hashCode());
        Long $points = this.getPoints();
        result = result * 59 + ($points == null ? 43 : ((Object)$points).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $keyword = this.getKeyword();
        result = result * 59 + ($keyword == null ? 43 : $keyword.hashCode());
        String $legal = this.getLegal();
        result = result * 59 + ($legal == null ? 43 : $legal.hashCode());
        String $legalTelephone = this.getLegalTelephone();
        result = result * 59 + ($legalTelephone == null ? 43 : $legalTelephone.hashCode());
        String $institutional = this.getInstitutional();
        result = result * 59 + ($institutional == null ? 43 : $institutional.hashCode());
        String $registerAddress = this.getRegisterAddress();
        result = result * 59 + ($registerAddress == null ? 43 : $registerAddress.hashCode());
        String $businessAddress = this.getBusinessAddress();
        result = result * 59 + ($businessAddress == null ? 43 : $businessAddress.hashCode());
        String $serviceScope = this.getServiceScope();
        result = result * 59 + ($serviceScope == null ? 43 : $serviceScope.hashCode());
        Point $lonLat = this.getLonLat();
        result = result * 59 + ($lonLat == null ? 43 : $lonLat.hashCode());
        String $organizationId = this.getOrganizationId();
        result = result * 59 + ($organizationId == null ? 43 : $organizationId.hashCode());
        CompanyStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        Timestamp $lastUpdatedTime = this.getLastUpdatedTime();
        result = result * 59 + ($lastUpdatedTime == null ? 43 : ((Object)$lastUpdatedTime).hashCode());
        String $superviseDepartId = this.getSuperviseDepartId();
        result = result * 59 + ($superviseDepartId == null ? 43 : $superviseDepartId.hashCode());
        String $superviseDepartName = this.getSuperviseDepartName();
        result = result * 59 + ($superviseDepartName == null ? 43 : $superviseDepartName.hashCode());
        String $industry = this.getIndustry();
        result = result * 59 + ($industry == null ? 43 : $industry.hashCode());
        Set<String> $scopePermissions = this.getScopePermissions();
        result = result * 59 + ($scopePermissions == null ? 43 : ((Object)$scopePermissions).hashCode());
        Set<String> $resourceTypes = this.getResourceTypes();
        result = result * 59 + ($resourceTypes == null ? 43 : ((Object)$resourceTypes).hashCode());
        Set<String> $followedDeviceNos = this.getFollowedDeviceNos();
        result = result * 59 + ($followedDeviceNos == null ? 43 : ((Object)$followedDeviceNos).hashCode());
        String $superviseRegionCode = this.getSuperviseRegionCode();
        result = result * 59 + ($superviseRegionCode == null ? 43 : $superviseRegionCode.hashCode());
        return result;
    }

    public String toString() {
        return "RdCompanyDocument(id=" + this.getId() + ", name=" + this.getName() + ", keyword=" + this.getKeyword() + ", legal=" + this.getLegal() + ", legalTelephone=" + this.getLegalTelephone() + ", institutional=" + this.getInstitutional() + ", registerAddress=" + this.getRegisterAddress() + ", businessAddress=" + this.getBusinessAddress() + ", countOfActivityStation=" + this.getCountOfActivityStation() + ", countOfSecurityMan=" + this.getCountOfSecurityMan() + ", countOfMan=" + this.getCountOfMan() + ", serviceScope=" + this.getServiceScope() + ", lonLat=" + this.getLonLat() + ", organizationId=" + this.getOrganizationId() + ", points=" + this.getPoints() + ", countOfDesk=" + this.getCountOfDesk() + ", countOfTemporaryProject=" + this.getCountOfTemporaryProject() + ", status=" + this.getStatus() + ", lastUpdatedTime=" + this.getLastUpdatedTime() + ", superviseDepartId=" + this.getSuperviseDepartId() + ", superviseDepartName=" + this.getSuperviseDepartName() + ", industry=" + this.getIndustry() + ", hasLonLatFlag=" + this.getHasLonLatFlag() + ", scopePermissions=" + this.getScopePermissions() + ", resourceTypes=" + this.getResourceTypes() + ", followedDeviceNos=" + this.getFollowedDeviceNos() + ", superviseRegionCode=" + this.getSuperviseRegionCode() + ")";
    }
}

