/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.domains.services.impls;

import com.bcxin.tenant.open.domains.dtos.CalculateCommunicatedDTO;
import com.bcxin.tenant.open.domains.entities.DeviceCommunicatedLogDetailEntity;
import com.bcxin.tenant.open.domains.entities.DeviceCommunicatedLogEntity;
import com.bcxin.tenant.open.domains.repositories.ConfigOfBillRepository;
import com.bcxin.tenant.open.domains.repositories.DeviceCommunicatedLogDetailRepository;
import com.bcxin.tenant.open.domains.repositories.DeviceCommunicatedLogRepository;
import com.bcxin.tenant.open.domains.repositories.RoomRepository;
import com.bcxin.tenant.open.domains.services.DeviceCommunicatedLogService;
import com.bcxin.tenant.open.domains.services.commands.CreateDeviceCommunicatedLogCommand;
import com.bcxin.tenant.open.domains.services.commands.CreateSyncDeviceCommunicatedLogCommand;
import com.bcxin.tenant.open.domains.utils.PointUtils;
import com.bcxin.tenant.open.infrastructures.UnitWork;
import com.bcxin.tenant.open.infrastructures.components.IdWorker;
import com.bcxin.tenant.open.infrastructures.components.JsonProvider;
import com.bcxin.tenant.open.infrastructures.exceptions.BadTenantException;
import com.bcxin.tenant.open.infrastructures.exceptions.NoFoundTenantException;
import com.bcxin.tenant.open.infrastructures.utils.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class DeviceCommunicatedLogServiceImpl
implements DeviceCommunicatedLogService {
    private static Logger logger = LoggerFactory.getLogger(DeviceCommunicatedLogServiceImpl.class);
    private final DeviceCommunicatedLogRepository deviceCommunicatedLogRepository;
    private final DeviceCommunicatedLogDetailRepository deviceCommunicatedLogDetailRepository;
    private final RoomRepository roomRepository;
    private final UnitWork unitWork;
    private final JsonProvider jsonProvider;
    private final IdWorker idWorker;
    private final ConfigOfBillRepository configOfBillRepository;

    public DeviceCommunicatedLogServiceImpl(DeviceCommunicatedLogRepository deviceCommunicatedLogRepository, DeviceCommunicatedLogDetailRepository deviceCommunicatedLogDetailRepository, RoomRepository roomRepository, UnitWork unitWork, JsonProvider jsonProvider, IdWorker idWorker, ConfigOfBillRepository configOfBillRepository) {
        this.deviceCommunicatedLogRepository = deviceCommunicatedLogRepository;
        this.deviceCommunicatedLogDetailRepository = deviceCommunicatedLogDetailRepository;
        this.roomRepository = roomRepository;
        this.unitWork = unitWork;
        this.jsonProvider = jsonProvider;
        this.idWorker = idWorker;
        this.configOfBillRepository = configOfBillRepository;
    }

    @Override
    public void dispatch(CreateDeviceCommunicatedLogCommand command) {
        Collection<DeviceCommunicatedLogDetailEntity> pendingLogDetails = command.getDeviceCommunicatedLogDetails();
        if (CollectionUtils.isEmpty(pendingLogDetails)) {
            return;
        }
        Collection toBeSavedLogDetails = pendingLogDetails.stream().filter(ii -> ii.getCalledDomainId() != null).collect(Collectors.toList());
        Collection calledDomainIds = toBeSavedLogDetails.stream().filter(ix -> StringUtils.hasLength((String)ix.getCalledDomainId())).map(ii -> ii.getCalledDomainId()).distinct().collect(Collectors.toList());
        Collection logs = calledDomainIds.stream().map(calledDomainId -> {
            Collection selectedLogDetails = toBeSavedLogDetails.stream().filter(ii -> !StringUtil.isEmpty((String)ii.getCalledDomainId()) && ii.getCalledDomainId().equalsIgnoreCase((String)calledDomainId)).collect(Collectors.toList());
            Optional firstSelectedLogOptional = selectedLogDetails.stream().sorted((i1, i2) -> {
                if (i1.getBeginTime() == null) {
                    return 0;
                }
                if (i2.getBeginTime() == null) {
                    return 0;
                }
                int flag = i1.getBeginTime().compareTo(i2.getBeginTime());
                return flag;
            }).findFirst();
            if (!firstSelectedLogOptional.isPresent()) {
                throw new NoFoundTenantException(String.format("\u627e\u4e0d\u5230\u8be5\u4f01\u4e1alog\u65e5\u5fd7:%s", calledDomainId));
            }
            DeviceCommunicatedLogDetailEntity selectedLog = (DeviceCommunicatedLogDetailEntity)((Object)((Object)firstSelectedLogOptional.get()));
            Optional<DeviceCommunicatedLogDetailEntity> lastSelectedLogOptional = toBeSavedLogDetails.stream().filter(ix -> StringUtils.hasLength((String)ix.getCalledDomainId())).filter(ii -> ii.getCalledDomainId().equalsIgnoreCase((String)calledDomainId)).sorted((i1, i2) -> {
                if (i1.getBeginTime() == null) {
                    return 0;
                }
                if (i2.getBeginTime() == null) {
                    return 0;
                }
                return i2.getBeginTime().compareTo(i1.getBeginTime());
            }).findFirst();
            if (!lastSelectedLogOptional.isPresent()) {
                throw new BadTenantException("\u65e0\u6548\u7684\u901a\u8baf\u65e5\u5fd7\u4fe1\u606f");
            }
            Collection calculatedLogs = toBeSavedLogDetails.stream().filter(ix -> ix.getCalledDomainId().equalsIgnoreCase((String)calledDomainId) && ix.getBeginTime() != null).collect(Collectors.toList());
            int dispatchTimeInMinuteInTotal = this.calculateTotalMinutesWithCommunicatedLogs(calculatedLogs);
            int pointsInTotal = toBeSavedLogDetails.stream().filter(ix -> ix.getCalledDomainId().equalsIgnoreCase((String)calledDomainId)).collect(Collectors.summingInt(ix -> ix.getPoints()));
            String domainHash = selectedLog.getCalledDomainId();
            DeviceCommunicatedLogEntity communicatedLog = DeviceCommunicatedLogEntity.create(selectedLog.getDeskType(), selectedLog.getPkId(), String.format("%s_%s", selectedLog.getRoomId(), domainHash), selectedLog.getBeginTime(), lastSelectedLogOptional.get().getEndTime(), selectedLog.getCommunicatedType(), selectedLog.getCallerUserId(), selectedLog.getCallerUserName(), selectedLog.getCallerCompanyName(), selectedLog.getCallerDevicePkId(), selectedLog.getCallerDeviceNo(), selectedLog.getCalledDomainId(), selectedLog.getDomainId(), dispatchTimeInMinuteInTotal, pointsInTotal, selectedLog.getCalledCompanyName(), selectedLog.getRoomId(), selectedLog.getReferenceType(), selectedLog.getReferenceNumber(), selectedLog.isPaidByCaller(), selectedLog.getCallerOrgInstitutional());
            logger.error("\u5f53\u524d\u4f01\u4e1a\u7684\u8c03\u5ea6\u65f6\u95f4\u4e3a:{} id={};roomId={};\u65f6\u95f4\u6bb5={};", new Object[]{dispatchTimeInMinuteInTotal, communicatedLog.getId(), selectedLog.getRoomId(), calculatedLogs.stream().map(ii -> String.format("beginTime=%s;endTime=%s;", ii.getBeginTime(), ii.getEndTime())).collect(Collectors.joining(";"))});
            selectedLogDetails.forEach(ix -> ix.assignLogId(communicatedLog.getId()));
            return communicatedLog;
        }).collect(Collectors.toList());
        String tranId = this.unitWork.beginTransaction();
        try {
            this.deviceCommunicatedLogRepository.batchInsert(logs);
            this.deviceCommunicatedLogDetailRepository.batchInsert(toBeSavedLogDetails);
            this.unitWork.commit(tranId);
        }
        catch (Exception ex) {
            this.unitWork.rollback(tranId);
            throw ex;
        }
    }

    @Override
    public void dispatch(CreateSyncDeviceCommunicatedLogCommand command) {
        String tranId = this.unitWork.beginTransaction();
        try {
            DeviceCommunicatedLogEntity deviceCommunicatedLog = (DeviceCommunicatedLogEntity)((Object)this.jsonProvider.toObject(DeviceCommunicatedLogEntity.class, command.getContent()));
            if (deviceCommunicatedLog == null) {
                throw new BadTenantException(String.format("\u65e0\u6548\u6570\u636e\u683c\u5f0f:%s", command.getContent()));
            }
            if (this.deviceCommunicatedLogRepository.getByNoPkId(deviceCommunicatedLog.getId()) != null) {
                this.deviceCommunicatedLogRepository.update(deviceCommunicatedLog);
            } else {
                this.deviceCommunicatedLogRepository.insert(deviceCommunicatedLog);
            }
            this.unitWork.commit(tranId);
        }
        catch (Exception ex) {
            this.unitWork.rollback(tranId);
            throw ex;
        }
    }

    private int calculateTotalMinutesWithCommunicatedLogs(Collection<DeviceCommunicatedLogDetailEntity> logs) {
        if (CollectionUtils.isEmpty(logs)) {
            return 0;
        }
        logs = logs.stream().sorted((i1, i2) -> {
            if (i1.getBeginTime() == null) {
                return 0;
            }
            if (i2.getBeginTime() == null) {
                return 0;
            }
            return i1.getBeginTime().compareTo(i2.getBeginTime());
        }).collect(Collectors.toList());
        ArrayList calculateCommunicatedDTOS = new ArrayList();
        logs.forEach(ic -> {
            Optional<CalculateCommunicatedDTO> ccDoptional = calculateCommunicatedDTOS.stream().filter(ii -> ii.getBeginTime().before(ic.getBeginTime()) && ii.getEndTime() != null && ic.getBeginTime().before(ii.getEndTime())).findFirst();
            if (!ccDoptional.isPresent()) {
                if (!calculateCommunicatedDTOS.stream().anyMatch(ii -> ii.getBeginTime().equals(ic.getBeginTime()) && (ii.getEndTime() == null || ic.getEndTime() == null || ii.getEndTime().equals(ic.getEndTime())))) {
                    calculateCommunicatedDTOS.add(CalculateCommunicatedDTO.create(ic.getBeginTime(), ic.getEndTime(), ic.getCalledUserId()));
                }
            } else if (ic.getEndTime() != null && ccDoptional.get().getEndTime().before(ic.getEndTime())) {
                ccDoptional.get().updateSwitchMaxEndTime(ic.getEndTime());
            }
        });
        Collection answeredCommunicatedDTOS = calculateCommunicatedDTOS.stream().filter(ii -> ii.getBeginTime() != null && ii.getEndTime() != null).collect(Collectors.toList());
        int sumInAnswer = answeredCommunicatedDTOS.stream().map(ii -> PointUtils.translate2DispatchTimeInMinutes(ii.getBeginTime(), ii.getEndTime())).collect(Collectors.summingInt(ii -> ii));
        int sumWithoutAnswer = 0;
        Collection noAnsweredCommunicatedDTOS = calculateCommunicatedDTOS.stream().filter(ii -> ii.getEndTime() == null).collect(Collectors.toList());
        for (CalculateCommunicatedDTO noAnswer : noAnsweredCommunicatedDTOS) {
            CalculateCommunicatedDTO firstSelectedCalculateCommunicated;
            if (answeredCommunicatedDTOS.stream().anyMatch(ix -> ix.getBeginTime().before(noAnswer.getBeginTime())) || (firstSelectedCalculateCommunicated = (CalculateCommunicatedDTO)answeredCommunicatedDTOS.stream().filter(ii -> ii.getBeginTime().after(noAnswer.getBeginTime())).sorted((i1, i2) -> {
                if (i1.getBeginTime() == null) {
                    return 0;
                }
                if (i2.getBeginTime() == null) {
                    return 0;
                }
                int flag = i1.getBeginTime().compareTo(i2.getBeginTime());
                return flag;
            }).findFirst().orElse(null)) == null) continue;
            int selectedInMinutes = PointUtils.translate2DispatchTimeInMinutes(firstSelectedCalculateCommunicated.getBeginTime(), firstSelectedCalculateCommunicated.getEndTime());
            int selectedNoAnswerInMinutes = PointUtils.translate2DispatchTimeInMinutes(noAnswer.getBeginTime(), firstSelectedCalculateCommunicated.getEndTime());
            if (selectedNoAnswerInMinutes - selectedInMinutes <= 0) continue;
            ++sumWithoutAnswer;
        }
        int sum = sumInAnswer + sumWithoutAnswer;
        return sum;
    }
}

