/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.backend.domain.utils;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.bcxin.backend.domain.configs.FileModeConfig;
import com.bcxin.backend.domain.utils.ftp.FtpUtil;
import com.bcxin.backend.domain.utils.ftp.UploadResult;
import com.google.common.collect.Maps;
import com.openhtmltopdf.extend.FSSupplier;
import com.openhtmltopdf.pdfboxout.PdfRendererBuilder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileTime;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.helper.W3CDom;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;

public class PDFUtils {
    private static final Logger logger = LoggerFactory.getLogger(PDFUtils.class);
    private static Map<String, String> tempHtmlMap = Maps.newHashMap();
    private static FSSupplier<InputStream> fSSupplier = null;

    public static void generatePdfByOpenhtmltopdf(String tempUrl, String pdfPath, Object formData) throws IOException {
        String htmlContent = tempHtmlMap.get(tempUrl);
        if (StringUtils.isEmpty((CharSequence)htmlContent)) {
            htmlContent = HttpUtil.get((String)tempUrl);
            tempHtmlMap.put(tempUrl, htmlContent);
        }
        String formStr = JSON.toJSONString((Object)formData);
        Map map = (Map)com.alibaba.fastjson.JSONObject.parseObject((String)formStr, Map.class);
        String zDay = ((String)map.get("zDay")).substring(0, 2);
        htmlContent = htmlContent.replace("${zYear}", (CharSequence)map.get("zYear")).replace("${zMonth}", (CharSequence)map.get("zMonth")).replace("${zDay}", zDay);
        htmlContent = PDFUtils.format(htmlContent, formData);
        Document document = Jsoup.parse((String)htmlContent);
        document.outputSettings().syntax(Document.OutputSettings.Syntax.html);
        try (FileOutputStream os = new FileOutputStream(pdfPath);){
            PdfRendererBuilder builder = new PdfRendererBuilder();
            builder.withUri(pdfPath);
            builder.toStream((OutputStream)os);
            builder.withW3cDocument(new W3CDom().fromJsoup(document), "");
            builder.useFont(PDFUtils.getFSSupplier("STSongti-SC-Regular.TTF"), "STSongti-SC-Regular");
            builder.run();
        }
    }

    private static String format(String content, Object formData) {
        JSONObject data = JSONObject.fromObject((Object)formData);
        String pattern = "\\$\\{(.+?)\\}";
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(content);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String key = m.group(1);
            Object value = data.get(key);
            m.appendReplacement(sb, value == null ? "" : value.toString());
        }
        m.appendTail(sb);
        return sb.toString();
    }

    private static FSSupplier<InputStream> getFSSupplier(final String path) {
        if (fSSupplier == null) {
            fSSupplier = new FSSupplier<InputStream>(){

                public InputStream supply() {
                    try {
                        ClassPathResource resource = new ClassPathResource(path);
                        return resource.getInputStream();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        return null;
                    }
                }
            };
        }
        return fSSupplier;
    }

    public static String uploadFtpFile(String pdfPath, String rootPath) {
        String outFilePath = rootPath + pdfPath;
        File outFile = new File(outFilePath);
        File[] fo = outFile.listFiles();
        ArrayList<String> successList = new ArrayList<String>();
        ArrayList<String> failList = new ArrayList<String>();
        if (fo == null || fo.length == 0) {
            logger.error("\u6240\u5728\u76ee\u5f55({})\u7684\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a", (Object)outFile);
            return null;
        }
        JSONObject json = new JSONObject();
        try {
            List<UploadResult> list = FtpUtil.upload((StrUtil.isEmpty((CharSequence)FileModeConfig.getFilePath()) ? "" : FileModeConfig.getFilePath()) + "/uploads/" + pdfPath.split("/uploads/")[1], fo);
            if (list == null) {
                list = FtpUtil.upload((StrUtil.isEmpty((CharSequence)FileModeConfig.getFilePath()) ? "" : FileModeConfig.getFilePath()) + "/uploads/" + pdfPath.split("/uploads/")[1], fo);
            }
            for (UploadResult result : list) {
                if (result.isResult()) {
                    logger.info("======>\u6587\u4ef6\u4e0a\u4f20FTP\u6210\u529f({})", (Object)result.getFileName());
                    successList.add(result.getFileName());
                    continue;
                }
                logger.error("======>\u6587\u4ef6\u4e0a\u4f20FTP\u5931\u8d25({})", (Object)result.getFileName());
                failList.add(result.getFileName());
            }
            String successFile = String.join((CharSequence)",", successList);
            String failFile = String.join((CharSequence)",", failList);
            json.put((Object)"success", (Object)successFile);
            json.put((Object)"fail", (Object)failFile);
        }
        catch (Exception e) {
            logger.error("======>\u4e0a\u4f20ftp\u5931\u8d25", (Throwable)e);
        }
        return json.toString();
    }

    public static String uploadDayFile(String pdfPath, String rootPath) {
        String outFilePath = rootPath + pdfPath;
        String dayFilePath = outFilePath.replace("/out", "/" + DateUtil.today());
        File dayFile = new File(dayFilePath);
        if (!dayFile.exists()) {
            dayFile.mkdirs();
        }
        File outFile = new File(outFilePath);
        File[] fo = outFile.listFiles();
        ArrayList<String> successList = new ArrayList<String>();
        ArrayList failList = new ArrayList();
        if (fo == null || fo.length == 0) {
            System.err.println("=======>\u4e0a\u4f20ftp \u6587\u4ef6\uff1aout\u76ee\u5f55\u6ca1\u6709\u6709\u6548\u6587\u4ef6<=======");
            return null;
        }
        JSONObject json = new JSONObject();
        try {
            for (int i = 0; i < fo.length; ++i) {
                Instant now;
                String fileName = fo[i].getName();
                String oPath = outFilePath + "/" + fileName;
                Path filePath = Paths.get(oPath, new String[0]);
                FileTime lastModifiedTime = Files.getLastModifiedTime(filePath, new LinkOption[0]);
                Instant lastModifiedInstant = Instant.ofEpochMilli(lastModifiedTime.toMillis());
                Duration duration = Duration.between(lastModifiedInstant, now = Instant.now());
                if (duration.toMinutes() <= 1L) continue;
                Files.move(Paths.get(oPath, new String[0]), Paths.get(dayFilePath + "/" + fileName, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                successList.add(fileName);
            }
            String successFile = String.join((CharSequence)",", successList);
            String failFile = String.join((CharSequence)",", failList);
            json.put((Object)"success", (Object)successFile);
            json.put((Object)"fail", (Object)failFile);
        }
        catch (Exception e) {
            System.err.println("=======>\u4e0a\u4f20ftp\u5931\u8d25\u4e86\uff1a" + e.getMessage() + "<=======");
        }
        return json.toString();
    }
}

