/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.backend.domain.syncs.services.impls;

import com.bcxin.backend.core.AppConfigProperty;
import com.bcxin.backend.core.components.StorageProvider;
import com.bcxin.backend.core.utils.ExceptionUtils;
import com.bcxin.backend.domain.models.DomainSuperviseDTO;
import com.bcxin.backend.domain.repositories.DomainSuperviseRepository;
import com.bcxin.backend.domain.services.DomainSuperviseService;
import com.bcxin.backend.domain.syncs.components.FormDataExporterImpl;
import com.bcxin.backend.domain.syncs.components.IFormDataExporter;
import com.bcxin.backend.domain.syncs.dtos.SyncDataMeta;
import com.bcxin.backend.domain.syncs.dtos.SyncDataSetDTO;
import com.bcxin.backend.domain.syncs.events.SyncDataQueueApplicationEvent;
import com.bcxin.backend.domain.syncs.repositories.DataSyncQueueRepository;
import com.bcxin.backend.domain.syncs.services.FormTableSyncService;
import com.bcxin.runtime.domain.enums.BooleanStatus;
import com.bcxin.runtime.domain.metas.entities.FormMetaEntity;
import com.bcxin.runtime.domain.metas.entities.FormSyncMetaEntity;
import com.bcxin.runtime.domain.metas.repositories.ApplicationMetaRepository;
import com.bcxin.runtime.domain.metas.repositories.FormSyncMetaRepository;
import com.bcxin.runtime.domain.snapshoots.FormSyncConfigSnapshot;
import com.bcxin.runtime.domain.snapshoots.FormSyncTargetConfigSnapshot;
import com.bcxin.runtime.domain.snapshoots.enums.SyncTargetType;
import com.bcxin.runtime.domain.syncs.dtos.DataSetDto;
import com.bcxin.runtime.domain.syncs.dtos.FormSyncConfigDto;
import com.bcxin.runtime.domain.syncs.entities.DataSyncQueueEntity;
import com.bcxin.runtime.domain.syncs.enums.SyncProcessStatus;
import com.bcxin.saas.core.components.JsonProvider;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
public class FormTableSyncServiceImpl
implements FormTableSyncService {
    private static Logger logger = LoggerFactory.getLogger(FormTableSyncServiceImpl.class);
    private final ApplicationMetaRepository applicationMetaRepository;
    private final FormSyncMetaRepository formSyncMetaRepository;
    private final FormDataExporterImpl formDataExporter;
    private final DataSyncQueueRepository dataSyncQueueRepository;
    private final JsonProvider jsonProvider;
    private final StorageProvider storageProvider;
    private final DomainSuperviseRepository domainSuperviseRepository;
    private final ApplicationEventPublisher eventPublisher;
    private final DomainSuperviseService domainSuperviseService;
    private final AppConfigProperty appConfigProperty;
    private static SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private static Map<Long, Collection<FormSyncMetaEntity>> cached_formSyncMetaEntities = new ConcurrentHashMap<Long, Collection<FormSyncMetaEntity>>();

    public FormTableSyncServiceImpl(ApplicationMetaRepository applicationMetaRepository, FormSyncMetaRepository formSyncMetaRepository, FormDataExporterImpl formDataExporter, DataSyncQueueRepository dataSyncQueueRepository, JsonProvider jsonProvider, StorageProvider storageProvider, DomainSuperviseRepository domainSuperviseRepository, ApplicationEventPublisher eventPublisher, DomainSuperviseService domainSuperviseService, AppConfigProperty appConfigProperty) {
        this.applicationMetaRepository = applicationMetaRepository;
        this.formSyncMetaRepository = formSyncMetaRepository;
        this.formDataExporter = formDataExporter;
        this.dataSyncQueueRepository = dataSyncQueueRepository;
        this.jsonProvider = jsonProvider;
        this.storageProvider = storageProvider;
        this.domainSuperviseRepository = domainSuperviseRepository;
        this.eventPublisher = eventPublisher;
        this.domainSuperviseService = domainSuperviseService;
        this.appConfigProperty = appConfigProperty;
    }

    @Override
    public void dispatch() {
        Collection formSyncMetaEntities = this.getAllOnlineFormSyncMetaEntities().stream().filter(ii -> {
            if (ii.getLastSyncedTime() == null) {
                return true;
            }
            try {
                Date lastSyncedTime = ii.getLastSyncedTime();
                return lastSyncedTime.before(Date.from(Instant.now().minus(2L, ChronoUnit.HOURS)));
            }
            catch (Exception ex) {
                logger.error(String.format("\u8f6c\u6362\u65f6\u95f4\u51fa\u9519:%s;\u660e\u7ec6:%s", ii.getLastSyncedTime(), ex.toString()), (Throwable)ex);
                return true;
            }
        }).collect(Collectors.toList());
        logger.error(String.format("2.\u603b\u5171\u6267\u884c\u7684\u8868\u5355\u5982\u4e0b:%s\u4e2a\u8868\u5355", formSyncMetaEntities.size() > 0 ? Integer.valueOf(formSyncMetaEntities.size()) : "\u3010\u540c\u6b65\u8868\u5355\u4e3a\u8fbe\u5230\u95f4\u9694\u65f6\u95f4(\u6bcf2\u5c0f\u65f61\u6b21)\u3011"));
        HashSet savedFormSyncMetaEntities = new HashSet();
        formSyncMetaEntities.stream().forEachOrdered(fsm -> {
            FormMetaEntity formMetaEntity = fsm.getFormMeta();
            String dsSql = null;
            try {
                FormSyncTargetConfigSnapshot targetConfigSnapshot = (FormSyncTargetConfigSnapshot)this.jsonProvider.getData(fsm.getTargetMetaEntity().getConfig(), FormSyncTargetConfigSnapshot.class);
                Timestamp fetchedModifiedTime = null;
                fetchedModifiedTime = fsm.getLastSyncedTime() != null ? Timestamp.from(Instant.ofEpochMilli(fsm.getLastSyncedTime().getTime())) : IFormDataExporter.DEFAULT_INITIAL_DATE;
                DataSetDto ds = null;
                int pageIndex = 0;
                do {
                    Collection zeroDataSyncQueueEntities;
                    ds = this.formDataExporter.export((FormSyncMetaEntity)fsm, fetchedModifiedTime, pageIndex);
                    dsSql = ds.getSql();
                    Collection<SyncDataSetDTO> syncDataSetDTOS = this.splitDataSetDtos(targetConfigSnapshot, ds, (FormSyncMetaEntity)fsm);
                    Timestamp finalFetchedModifiedTime = fetchedModifiedTime;
                    int finalPageIndex = pageIndex;
                    Collection totalDataSyncQueueEntities = syncDataSetDTOS.stream().map(syncDataSetDTO -> this.translate2DataSyncQueueEntity((FormSyncMetaEntity)fsm, (SyncDataSetDTO)syncDataSetDTO, finalFetchedModifiedTime, finalPageIndex)).collect(Collectors.toList());
                    Collection dataSyncQueueEntities = totalDataSyncQueueEntities.stream().filter(ii -> ii.getSize() > 0).collect(Collectors.toList());
                    dataSyncQueueEntities.forEach(ii -> this.eventPublisher.publishEvent((ApplicationEvent)SyncDataQueueApplicationEvent.create(ii)));
                    if (ds.getRows().size() == 0 || ds.getRows().size() < 20) {
                        Timestamp comparedDate = Timestamp.from(Instant.now().minus(2L, ChronoUnit.SECONDS));
                        Date updateDoneSyncDate = fsm.getLastSyncedTime();
                        if (comparedDate.after(fsm.getLastSyncedTime())) {
                            updateDoneSyncDate = comparedDate;
                        }
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTime(updateDoneSyncDate);
                        calendar.add(13, 1);
                        updateDoneSyncDate = calendar.getTime();
                        fsm.markSyncQueue(updateDoneSyncDate, fsm.getSyncedRecordCount(), fsm.getNote());
                    }
                    if ((zeroDataSyncQueueEntities = (Collection)totalDataSyncQueueEntities.stream().filter(ii -> ii.getSize() == 0).collect(Collectors.toList())).size() > 0) {
                        logger.error(String.format("%s:\u8868[%s]\u6267\u884c\u5b8c\u6bd5;\u7ed3\u679c=%s; \u603b\u5171%s\u6761\u6570\u636e,\u67e5\u8be2sql\u4e3a(%s)", Instant.now(), formMetaEntity.getTableName(), fsm.getNote(), zeroDataSyncQueueEntities.size(), dsSql));
                    }
                    savedFormSyncMetaEntities.add(fsm);
                    this.commitData2Db(savedFormSyncMetaEntities, dataSyncQueueEntities);
                    ++pageIndex;
                } while (ds != null && ds.getRows().size() > 0);
            }
            catch (Exception ex) {
                try {
                    logger.error("\u8868{}\u521b\u5efaqueues\u6570\u636e\u5f02\u5e38\uff0c\u67e5\u8be2sql\u4e3a\uff1a{},\u5f02\u5e38\u4e3a\uff1a{}", new Object[]{formMetaEntity.getTableName(), dsSql, ex});
                    fsm.markSyncQueue(fsm.getLastSyncedTime(), -1, String.format("%s: \u6267\u884c\u540c\u6b65\u5931\u8d25: %s", new Date(), ExceptionUtils.getStackMessage((Throwable)ex)));
                }
                catch (Throwable throwable) {
                    Calendar calendar = Calendar.getInstance();
                    if (calendar.get(13) % 20 == 0) {
                        logger.error(String.format("%s:\u8868[%s]\u6267\u884c\u5b8c\u6bd5;\u7ed3\u679c=%s", Instant.now(), formMetaEntity.getTableName(), fsm.getNote()));
                    }
                    throw throwable;
                }
                Calendar calendar = Calendar.getInstance();
                if (calendar.get(13) % 20 == 0) {
                    logger.error(String.format("%s:\u8868[%s]\u6267\u884c\u5b8c\u6bd5;\u7ed3\u679c=%s", Instant.now(), formMetaEntity.getTableName(), fsm.getNote()));
                }
            }
            Calendar calendar = Calendar.getInstance();
            if (calendar.get(13) % 20 == 0) {
                logger.error(String.format("%s:\u8868[%s]\u6267\u884c\u5b8c\u6bd5;\u7ed3\u679c=%s", Instant.now(), formMetaEntity.getTableName(), fsm.getNote()));
            }
        });
    }

    private DataSyncQueueEntity translate2DataSyncQueueEntity(FormSyncMetaEntity formSyncMetaEntity, SyncDataSetDTO syncDataSetDTO, Timestamp startDateTime, int pageIndex) {
        DataSetDto ds = syncDataSetDTO.getDataSetDto();
        String data = null;
        try {
            data = this.jsonProvider.getJson((Object)syncDataSetDTO);
        }
        catch (Exception e) {
            logger.error("translate2DataSyncQueueEntity\u8f6c\u6362\u6570\u636e\u5f02\u5e38\uff0c{}", (Throwable)e);
        }
        if (StringUtils.isEmpty((Object)data)) {
            DataSyncQueueEntity dataSyncQueueEntity = DataSyncQueueEntity.create(null, null, (int)0, (boolean)false, null, null);
            return dataSyncQueueEntity;
        }
        String path = String.format("/uploads/sync/request/form/%s/%s-%s.txt", simpleDateFormat.format(new Date()), ds.getTableName(), UUID.randomUUID());
        byte[] content = data.getBytes(StandardCharsets.UTF_8);
        String realPath = this.storageProvider.save(path, content);
        Collection processedDataIds = ds.getRows().stream().limit(20L).map(ii -> String.valueOf(ii.getId())).collect(Collectors.toList());
        SyncDataMeta dataMeta = SyncDataMeta.create(path, ds.getRows().size(), realPath, processedDataIds);
        FormSyncConfigDto configVo = this.getFormSyncConfigDto(formSyncMetaEntity);
        String formSyncConfig = this.jsonProvider.getJson((Object)configVo);
        String tableName = ds.getTableName();
        try {
            String enterpriseDesc = null;
            enterpriseDesc = syncDataSetDTO.getSyncTargetType() == SyncTargetType.SyncViaFTP ? (syncDataSetDTO.getDomainSuperviseDTO() == null || syncDataSetDTO.getDomainSuperviseDTO().getSupervise() == null ? "\u65e0\u5f52\u5c5e\u5730" : syncDataSetDTO.getDomainSuperviseDTO().getSupervise().getTargetApp()) : "\u76f4\u63a5\u63a8\u9001\u5230\u76ee\u6807API";
            tableName = String.format("\u4f01\u4e1a-[%s]: %s", enterpriseDesc, ds.getSql());
            if (StringUtils.hasLength((String)syncDataSetDTO.getNote())) {
                tableName = "\u5408\u5e76:" + tableName;
            }
        }
        catch (Exception ex) {
            logger.error(String.format("ds\u6570\u636e(%s)\u96c6\u4fe1\u606f\u4e0d\u7b26\u5408\u8981\u6c42:%s", ds.getTableName(), ExceptionUtils.getStackMessage((Throwable)ex)));
        }
        boolean needSyncFile = ds.getRows().stream().anyMatch(ii -> ii.getFieldValues().stream().anyMatch(ix -> ix.getIsFileValue()));
        DataSyncQueueEntity dataSyncQueueEntity = DataSyncQueueEntity.create((String)tableName, (String)this.jsonProvider.getJson((Object)dataMeta), (int)ds.getRows().size(), (boolean)needSyncFile, (String)configVo.getFormSyncId(), (String)formSyncConfig);
        FormSyncTargetConfigSnapshot targetConfigSnapshot = (FormSyncTargetConfigSnapshot)this.jsonProvider.getData(formSyncMetaEntity.getTargetMetaEntity().getConfig(), FormSyncTargetConfigSnapshot.class);
        if (ds.getRows().size() == 0) {
            dataSyncQueueEntity.changeDataSyncStatus(SyncProcessStatus.Done, "\u65e0\u4efb\u4f55\u6570\u636e\u9700\u8981\u8fdb\u884c\u540c\u6b65!");
            dataSyncQueueEntity.changeFileSyncStatus(SyncProcessStatus.Done, "\u65e0\u4efb\u4f55\u6587\u4ef6\u4fe1\u606f\uff0c\u76f4\u63a5\u8fdb\u884c\u6570\u636e\u540c\u6b65!");
        } else if (syncDataSetDTO.getDomainSuperviseDTO() == null || syncDataSetDTO.getDomainSuperviseDTO().getSupervise() == null) {
            if (syncDataSetDTO.getSyncTargetType() == SyncTargetType.SyncViaFTP) {
                dataSyncQueueEntity.changeDataSyncStatus(SyncProcessStatus.Done, "\u65e0\u76d1\u7ba1\u5f52\u5c5e\u4fe1\u606f\uff0c\u6682\u65e0\u9700\u8fdb\u884c\u6570\u636e\u540c\u6b65");
                dataSyncQueueEntity.changeFileSyncStatus(SyncProcessStatus.Done, "\u65e0\u76d1\u7ba1\u5f52\u5c5e\u4fe1\u606f\uff0c\u6682\u65e0\u9700\u8fdb\u884c\u6587\u4ef6\u540c\u6b65");
            } else {
                dataSyncQueueEntity.changeDataSyncStatus(SyncProcessStatus.Initialize, "\u76f4\u63a5\u901a\u8fc7\u6570\u636eAPI\u8fdb\u884c\u540c\u6b65\u5373\u53ef");
                dataSyncQueueEntity.changeFileSyncStatus(SyncProcessStatus.Done, "\u6570\u636e/\u6587\u4ef6API\u5df2\u7ecf\u5408\u5e76\u5230\u540c\u4e00\u4e2a\u76ee\u6807API");
            }
        } else if (targetConfigSnapshot.getTargetType() == SyncTargetType.SyncViaFTP) {
            if (!this.appConfigProperty.isSyncViaFtp(syncDataSetDTO.getDomainSuperviseDTO().getSupervise().getTargetApp())) {
                String desc = String.format("\u8be5\u6570\u636e(%s)\u4e0d\u8d70\u6446\u6e21\u670d\u52a1\u4ee3\u7406\u6a21\u5f0f", syncDataSetDTO.getDomainSuperviseDTO().getSupervise().getTargetApp());
                dataSyncQueueEntity.changeDataSyncStatus(SyncProcessStatus.DoneViaFTP, desc);
                dataSyncQueueEntity.changeFileSyncStatus(SyncProcessStatus.DoneViaFTP, desc);
            } else if (dataSyncQueueEntity.getNeedSyncFile() == BooleanStatus.TRUE && ds.getRows().stream().flatMap(ix -> ix.getFieldValues().stream()).anyMatch(ix -> ix.isValidFile())) {
                dataSyncQueueEntity.changeDataSyncStatus(SyncProcessStatus.DoneViaFTP, "\u5982\u679c\u4e5f\u6709\u6587\u4ef6\u9700\u8981\u540c\u6b65, \u90a3\u4e48\u6570\u636e\u548c\u6587\u4ef6\u5c06\u4e00\u8d77\u6253\u5305\u8fdb\u884c\u540c\u6b65");
                dataSyncQueueEntity.changeFileSyncStatus(SyncProcessStatus.SyncViaFTP, "\u7b49\u5f85(\u6570\u636e\u548c\u6587\u4ef6)\u5bf9\u63a5\u6446\u6e21\u670d\u52a1\u8fdb\u884c\u540c\u6b65");
            } else {
                dataSyncQueueEntity.changeDataSyncStatus(SyncProcessStatus.SyncViaFTP, "\u7b49\u5f85\u6570\u636e\u5bf9\u63a5\u6446\u6e21\u670d\u52a1\u8fdb\u884c\u540c\u6b65");
                dataSyncQueueEntity.changeFileSyncStatus(SyncProcessStatus.DoneViaFTP, "\u65e0\u6587\u4ef6\u7b49\u5f85\u6446\u6e21\u670d\u52a1\u8fdb\u884c\u540c\u6b65");
            }
        }
        return dataSyncQueueEntity;
    }

    @Transactional
    protected void commitData2Db(Collection<FormSyncMetaEntity> formSyncMetaEntities, Collection<DataSyncQueueEntity> dataSyncQueueEntities) {
        if (dataSyncQueueEntities.size() > 0) {
            this.dataSyncQueueRepository.saveAll(dataSyncQueueEntities);
            dataSyncQueueEntities.clear();
        }
        if (formSyncMetaEntities.size() > 0) {
            this.formSyncMetaRepository.saveAll(formSyncMetaEntities);
            formSyncMetaEntities.clear();
        }
    }

    private FormSyncConfigDto getFormSyncConfigDto(FormSyncMetaEntity formSyncMetaEntity) {
        FormSyncConfigSnapshot syncConfigSnapshot = (FormSyncConfigSnapshot)this.jsonProvider.getData(formSyncMetaEntity.getConfig(), FormSyncConfigSnapshot.class);
        FormSyncTargetConfigSnapshot targetConfigSnapshot = (FormSyncTargetConfigSnapshot)this.jsonProvider.getData(formSyncMetaEntity.getTargetMetaEntity().getConfig(), FormSyncTargetConfigSnapshot.class);
        FormSyncConfigDto configVo = FormSyncConfigDto.create((String)formSyncMetaEntity.getId(), (String)syncConfigSnapshot.getMapKey(), (FormSyncTargetConfigSnapshot)targetConfigSnapshot, (String)syncConfigSnapshot.getOtherTargetApp());
        return configVo;
    }

    private Collection<SyncDataSetDTO> splitDataSetDtos(FormSyncTargetConfigSnapshot targetConfigSnapshot, DataSetDto dataSetDto, FormSyncMetaEntity formSyncMetaEntity) {
        if (targetConfigSnapshot.getTargetType() == SyncTargetType.Direct2V5) {
            DataSetDto dsDto = DataSetDto.create((String)dataSetDto.getTableName(), (int)dataSetDto.getTotalCount(), (Collection)dataSetDto.getColumns(), (Collection)dataSetDto.getRows());
            dsDto.setSql(dataSetDto.getSql());
            return Collections.singleton(SyncDataSetDTO.create(targetConfigSnapshot.getTargetType(), dsDto, null));
        }
        Collection syncDataSetDTOS = null;
        Collection domainIds = dataSetDto.getRows().stream().map(ii -> ii.getDomainId()).filter(ii -> StringUtils.hasLength((String)ii) && !"null".equalsIgnoreCase((String)ii)).collect(Collectors.toList());
        Collection<DomainSuperviseDTO> domainSuperviseDTOS = this.domainSuperviseService.getByDomainIds(domainIds);
        syncDataSetDTOS = domainSuperviseDTOS.stream().map(ii -> {
            Collection rows = dataSetDto.getRows().stream().filter(ix -> {
                if (!StringUtils.hasLength((String)ix.getDomainId()) || "null".equalsIgnoreCase(ix.getDomainId())) {
                    return !StringUtils.hasLength((String)ii.getDomainId()) || "null".equalsIgnoreCase(ii.getDomainId());
                }
                return ix.getDomainId().equalsIgnoreCase(ii.getDomainId());
            }).collect(Collectors.toList());
            DataSetDto selectedDataSetDto = DataSetDto.create((String)dataSetDto.getTableName(), (int)dataSetDto.getTotalCount(), (Collection)dataSetDto.getColumns(), (Collection)rows);
            selectedDataSetDto.markInfo(dataSetDto.getSql(), dataSetDto.getFetchedModifiedTime(), dataSetDto.getExportedTime());
            return SyncDataSetDTO.create(targetConfigSnapshot.getTargetType(), selectedDataSetDto, ii);
        }).collect(Collectors.toList());
        if (syncDataSetDTOS == null || syncDataSetDTOS.size() == 0) {
            DataSetDto dsDto = DataSetDto.create((String)dataSetDto.getTableName(), (int)dataSetDto.getTotalCount(), (Collection)dataSetDto.getColumns(), (Collection)dataSetDto.getRows());
            return Collections.singleton(SyncDataSetDTO.create(targetConfigSnapshot.getTargetType(), dsDto, null));
        }
        ArrayList<SyncDataSetDTO> combinedSyncs = new ArrayList<SyncDataSetDTO>();
        syncDataSetDTOS.forEach(sync -> {
            SyncDataSetDTO selectedDataSetDto = null;
            Optional<SyncDataSetDTO> selectedDataSetOptional = combinedSyncs.stream().filter(ii -> ii.getSyncTargetType().equals((Object)sync.getSyncTargetType()) && ii.getIdentityValue().equals(sync.getIdentityValue())).findFirst();
            if (selectedDataSetOptional.isPresent()) {
                selectedDataSetDto = selectedDataSetOptional.get();
            } else {
                selectedDataSetDto = SyncDataSetDTO.create(sync.getSyncTargetType(), sync.getDataSetDto(), sync.getDomainSuperviseDTO());
                combinedSyncs.add(selectedDataSetDto);
            }
            for (DataSetDto.Row sync_row : sync.getDataSetDto().getRows().stream().collect(Collectors.toList())) {
                if (selectedDataSetDto.getDataSetDto().getRows().stream().anyMatch(ix -> ix.getId().equals(sync_row.getId()))) continue;
                selectedDataSetDto.getDataSetDto().getRows().add(sync_row);
            }
            ArrayList deletedIds = selectedDataSetDto.getDataSetDto().getDeletedIds();
            if (deletedIds == null) {
                deletedIds = new ArrayList();
            }
            if (sync.getDataSetDto().getDeletedIds() != null) {
                deletedIds.addAll(sync.getDataSetDto().getDeletedIds());
            }
            selectedDataSetDto.getDataSetDto().setDeletedIds(deletedIds);
            int totalCount = selectedDataSetDto.getDataSetDto().getTotalCount();
            selectedDataSetDto.getDataSetDto().setTotalCount(totalCount + sync.getDataSetDto().getTotalCount());
            selectedDataSetDto.markNote(String.format("\u5408\u5e76:%s_%s", selectedDataSetDto.getKeyValue(), sync.getKeyValue()));
        });
        return combinedSyncs;
    }

    protected Collection<FormSyncMetaEntity> getAllOnlineFormSyncMetaEntities() {
        Collection<Object> selected_formSyncMetaEntities = null;
        for (Long expiredValue : cached_formSyncMetaEntities.keySet()) {
            if (expiredValue <= Instant.now().getEpochSecond()) continue;
            selected_formSyncMetaEntities = cached_formSyncMetaEntities.get(expiredValue);
        }
        if (selected_formSyncMetaEntities == null) {
            selected_formSyncMetaEntities = this.formSyncMetaRepository.findAllOnline();
            cached_formSyncMetaEntities.clear();
            Instant expiredInstant = Instant.now().minus(-10L, ChronoUnit.MINUTES);
            Long expiredValueInSeconds = expiredInstant.getEpochSecond();
            cached_formSyncMetaEntities.put(expiredValueInSeconds, selected_formSyncMetaEntities);
            logger.error(String.format("%s: Collection<FormSyncMetaEntity>\u8fc7\u671f\u65f6\u95f4\u4e3a: %s \u540e", Instant.now(), Timestamp.from(expiredInstant)));
        }
        return selected_formSyncMetaEntities;
    }
}

