/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.backend.domain.syncs.repositories;

import com.bcxin.runtime.domain.syncs.entities.DataSyncQueueEntity;
import java.util.Date;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

public interface DataSyncQueueRepository
extends JpaRepository<DataSyncQueueEntity, String> {
    @Query(value="select d from DataSyncQueueEntity d where d.status=com.bcxin.runtime.domain.syncs.enums.SyncProcessStatus.Initialize order by d.createdTime asc ")
    public Page<DataSyncQueueEntity> getPendingData(Pageable var1);

    @Query(value="select d from DataSyncQueueEntity d where d.fileSyncStatus=com.bcxin.runtime.domain.syncs.enums.SyncProcessStatus.Initialize  order by d.createdTime asc ")
    public Page<DataSyncQueueEntity> getPendingFiles(Pageable var1);

    @Query(value="select d from DataSyncQueueEntity d where d.status=com.bcxin.runtime.domain.syncs.enums.SyncProcessStatus.SyncViaFTP  order by d.createdTime asc ")
    public Page<DataSyncQueueEntity> getPendingFtpData(Pageable var1);

    @Query(value="select d from DataSyncQueueEntity d where d.fileSyncStatus=com.bcxin.runtime.domain.syncs.enums.SyncProcessStatus.SyncViaFTP  order by d.createdTime asc ")
    public Page<DataSyncQueueEntity> getPendingFtpFilesData(Pageable var1);

    @Query(value="select count(d) from DataSyncQueueEntity d where d.fileSyncStatus=com.bcxin.runtime.domain.syncs.enums.SyncProcessStatus.Initialize or d.status= com.bcxin.runtime.domain.syncs.enums.SyncProcessStatus.Initialize ")
    public int getPendingCount();

    @Query(value="select d from DataSyncQueueEntity d where d.retryCount<2 and d.status in (com.bcxin.runtime.domain.syncs.enums.SyncProcessStatus.Error,com.bcxin.runtime.domain.syncs.enums.SyncProcessStatus.ErrorViaFTP)  order by d.createdTime asc ")
    public Page<DataSyncQueueEntity> getRetryableQueueData(Pageable var1);

    @Query(value="select d from DataSyncQueueEntity d where d.retryCount<2 and d.fileSyncStatus in (com.bcxin.runtime.domain.syncs.enums.SyncProcessStatus.Error,com.bcxin.runtime.domain.syncs.enums.SyncProcessStatus.ErrorViaFTP)  order by d.createdTime asc ")
    public Page<DataSyncQueueEntity> getRetryableQueueFile(Pageable var1);

    @Query(value="select d from DataSyncQueueEntity d where d.createdTime<=?1 and d.isArchived=com.bcxin.runtime.domain.enums.BooleanStatus.FALSE and d.status in (com.bcxin.runtime.domain.syncs.enums.SyncProcessStatus.Done,com.bcxin.runtime.domain.syncs.enums.SyncProcessStatus.DoneViaFTP) and d.fileSyncStatus in (com.bcxin.runtime.domain.syncs.enums.SyncProcessStatus.Done,com.bcxin.runtime.domain.syncs.enums.SyncProcessStatus.DoneViaFTP)  order by d.createdTime asc ")
    public Page<DataSyncQueueEntity> getDoneSyncQueues(Date var1, Pageable var2);
}

