/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.backend.domain.repositories.dtos;

import com.bcxin.backend.domain.models.SuperviseDTO;
import java.util.Collection;
import java.util.HashSet;

public class RegionSystemDomainGroupDTO {
    private Collection<String> domainIds;
    private final SuperviseDTO superviseDTO;

    public RegionSystemDomainGroupDTO(SuperviseDTO superviseDTO) {
        this.superviseDTO = superviseDTO;
        this.setDomainIds(new HashSet<String>());
    }

    public void addDomainId(String domainId) {
        this.domainIds.add(domainId);
    }

    public boolean isExists(String domainId) {
        return this.getDomainIds().stream().anyMatch(ii -> ii.equalsIgnoreCase(domainId));
    }

    public boolean isRegionMatch(String regionId) {
        return this.getSuperviseDTO().getRegionId().equalsIgnoreCase(regionId);
    }

    public static RegionSystemDomainGroupDTO create(SuperviseDTO superviseDTO) {
        return new RegionSystemDomainGroupDTO(superviseDTO);
    }

    public Collection<String> getDomainIds() {
        return this.domainIds;
    }

    public SuperviseDTO getSuperviseDTO() {
        return this.superviseDTO;
    }

    public void setDomainIds(Collection<String> domainIds) {
        this.domainIds = domainIds;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RegionSystemDomainGroupDTO)) {
            return false;
        }
        RegionSystemDomainGroupDTO other = (RegionSystemDomainGroupDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Collection<String> this$domainIds = this.getDomainIds();
        Collection<String> other$domainIds = other.getDomainIds();
        if (this$domainIds == null ? other$domainIds != null : !((Object)this$domainIds).equals(other$domainIds)) {
            return false;
        }
        SuperviseDTO this$superviseDTO = this.getSuperviseDTO();
        SuperviseDTO other$superviseDTO = other.getSuperviseDTO();
        return !(this$superviseDTO == null ? other$superviseDTO != null : !((Object)this$superviseDTO).equals(other$superviseDTO));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RegionSystemDomainGroupDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Collection<String> $domainIds = this.getDomainIds();
        result = result * 59 + ($domainIds == null ? 43 : ((Object)$domainIds).hashCode());
        SuperviseDTO $superviseDTO = this.getSuperviseDTO();
        result = result * 59 + ($superviseDTO == null ? 43 : ((Object)$superviseDTO).hashCode());
        return result;
    }

    public String toString() {
        return "RegionSystemDomainGroupDTO(domainIds=" + this.getDomainIds() + ", superviseDTO=" + this.getSuperviseDTO() + ")";
    }
}

