/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.backend.domain.auth.service.impl;

import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import cn.hutool.http.Method;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.backend.domain.auth.dtos.AuthLog;
import com.bcxin.backend.domain.auth.dtos.AuthRequestDto;
import com.bcxin.backend.domain.auth.service.AuthenticationService;
import com.bcxin.backend.domain.models.Result;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

@Component(value="auth_common")
public class AuthenticationServiceImpl
implements AuthenticationService {
    private static final Logger log = LoggerFactory.getLogger(AuthenticationServiceImpl.class);
    private final String BaseUrl;
    private final JdbcTemplate jdbcTemplate;

    public AuthenticationServiceImpl(@Value(value="${myapps.authentication.api}") String baseUrl, @Qualifier(value="primaryJdbcTemplate") JdbcTemplate jdbcTemplate) {
        this.BaseUrl = baseUrl;
        this.jdbcTemplate = jdbcTemplate;
    }

    @Override
    public Result auth(Collection<AuthRequestDto> list) {
        ArrayList<AuthLog> result = new ArrayList();
        ArrayList<String> loggingList = new ArrayList<String>();
        HashMap paramMap = Maps.newHashMapWithExpectedSize((int)8);
        paramMap.put("authLogs", JSON.toJSONString(list));
        HttpResponse response = HttpUtil.createRequest((Method)Method.POST, (String)this.BaseUrl).form((Map)paramMap).timeout(60000).execute();
        JSONObject jsonObject = JSON.parseObject((String)response.body());
        if (jsonObject.get((Object)"data") != null) {
            result = JSONObject.parseArray((String)jsonObject.getString("data"), AuthLog.class);
            this.setLogList(loggingList, "1", result);
        }
        this.saveLog(loggingList);
        return new Result<ArrayList<AuthLog>>().success("\u64cd\u4f5c\u6210\u529f\uff01", result);
    }

    private void setLogList(List<String> list, String type, List<AuthLog> result) {
        for (AuthLog authLog : result) {
            list.add("( '" + type + "',NOW(),'" + authLog.getIdNumber() + "','\u5b9e\u540d\u8ba4\u8bc1','" + authLog.getAuthResult() + "' )");
        }
    }

    private void saveLog(List<String> list) {
        if (list.size() > 0) {
            String lStr = list.toString();
            StringBuilder sb = new StringBuilder();
            sb.append("INSERT INTO bg_screening_user_exec_logs (type,created_time,idnum,short_result,result) values" + lStr.substring(1, lStr.length() - 1));
            this.jdbcTemplate.update(sb.toString());
        }
    }
}

