import request from '/@/utils/request';

// 查询分页发票源单据
export function getFapiaoSourceList(data : any, page : any, limit : any) {
	return request({
		url: `/api/front/fapiao/source/list?page=${page}&limit=${limit}`,
		method: 'post',
		data: data
	});
}

// 获取列表统计数据
export function getFapiaoSourceSummary(data : any) {
	return request({
		url: '/api/front/fapiao/source/summary',
		method: 'post',
		data: data
	});
}

// 获取商品分类缓存树
export function getCategoryCacheTree() {
	return request({
		url: '/api/front/product/category/get/tree',
		method: 'get',
	});
}

// 查询分页发票抬头表
export function getFapiaoTitleList(params : any) {
	return request({
		url: '/api/front/fapiao/title/list',
		method: 'get',
		params: params
	});
}

// 新增发票申请单
export function getFapiaoApplyCreate(data : any) {
	return request({
		url: '/api/front/fapiao/apply/create',
		method: 'post',
		data: data
	});
}

// 查询最后一次收票人信息
export function getFapiaoApplyLastSend() {
	return request({
		url: '/api/front/fapiao/apply/last/send/to',
		method: 'get',
	});
}

// 查询单条发票申请单
export function getFapiaoApplyInfo(applyNo : any) {
	return request({
		url: `/api/front/fapiao/apply/info/${applyNo}`,
		method: 'get',
	});
}

// 开票方 查询分页发票申请单
export function getFapiaoApplyWriterList(params : any) {
	return request({
		url: '/api/front/fapiao/apply/writer/list',
		method: 'get',
		params: params
	});
}

// 开票方 获取列表统计数据
export function getFapiaoApplyWriterSummary(params : any) {
	return request({
		url: '/api/front/fapiao/apply/writer/summary',
		method: 'get',
		params: params
	});
}