import request from '/@/utils/request';

// 查询分页发票申请单
export function getFapiaoApplyList(data : any, page : any, limit : any) {
	return request({
		url: `/api/front/fapiao/apply/writer/list?page=${page}&limit=${limit}`,
		method: 'post',
		data: data
	});
}

// 开票方 获取列表统计数据
export function getFapiaoApplyWriterSummary(data : any) {
	return request({
		url: '/api/front/fapiao/apply/writer/summary',
		method: 'post',
		data: data
	});
}

// 拒绝开票
export function fapiaoApplyReject(data : any) {
	return request({
		url: '/api/front/fapiao/apply/reject',
		method: 'post',
		data: data
	});
}

// 开票方 发票查询-导出excel
export function fapiaoWriterExcel(data : any) {
	return request({
		url: '/api/front/fapiao/writer/excel',
		method: 'post',
		data: data,
		responseType: 'blob',
	});
}

// 查询单条发票申请单
export function getFapiaoApplyById(id : any) {
	return request({
		url: `/api/front/fapiao/apply/info/${id}`,
		method: 'get'
	});
}