package com.bcxin.filters;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.header.Header;
import org.apache.kafka.connect.transforms.Transformation;

import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RegionCodeFilter<R extends ConnectRecord<R>> implements Transformation<R> {
    private static Collection<String> securityInstitutionalCodeStuffs =
            Stream.of("07","08","09","10")
            .collect(Collectors.toSet());
    @Override
    public R apply(R record) {
        if(!record.topic().contains("binlog-cdc.topic")) {
            return record;
        }

        StringBuilder sb = new StringBuilder();
        try {
            Iterable<Header> headers = record.headers();
            AtomicReference<String> regionCodeValue = new AtomicReference<>();
            AtomicReference<String> institutionalCodeValue = new AtomicReference<>();
            headers.forEach(header -> {
                String headValue = new String((byte[]) header.value(), StandardCharsets.UTF_8);
                String headerKey = header.key();

                if (headerKey.equalsIgnoreCase("region_code")) {
                    regionCodeValue.set(headValue);
                    sb.append(String.format("region_code=%s;",  headValue));
                }else if(headerKey.equalsIgnoreCase("org_id")) {
                    sb.append(String.format("org_id=%s;", headValue));
                }else if(headerKey.equalsIgnoreCase("institutional_code")) {
                    institutionalCodeValue.set(headValue);
                }
            });

            Header regionHeader = record.headers().lastWithName("region_code");
            if (regionHeader != null) {
                String region = new String((byte[]) regionHeader.value(), StandardCharsets.UTF_8);
                sb.append(String.format("通过lastWithName 获取的区域信息:%s;", region));
            } else {
                sb.append("找不到头信息");
            }

            if (regionCodeValue.get() != null && regionCodeValue.get().startsWith("1405")) {


                if(institutionalCodeValue.get()!=null &&
                        securityInstitutionalCodeStuffs.stream().anyMatch(ix->institutionalCodeValue.get().endsWith(ix))) {
                    System.err.println(String.format("v6.(topic=%s)当前的头部信息为:%s; 监管数据(%s)-不符合条件的数据",
                            record.topic(), sb,
                            institutionalCodeValue.get()));
                    return null;
                }

                System.err.println(String.format("v6.(topic=%s)当前的头部信息为:符合条件的数据-%s", record.topic(), sb.toString()));
                return record;
            }

            return null;
        } finally {

        }
    }

    @Override
    public ConfigDef config() {
        return new ConfigDef();
    }

    @Override
    public void close() {

    }

    @Override
    public void configure(Map<String, ?> map) {

    }
}