import AMap from "@/components/AMap/map/index";
import AInfoWindow from "@/components/AMap/infowindow/index";

const components = [AMap, AInfoWindow];

const install = function (Vue) {
  if (install.installed) return;
  components.forEach((component) => {
    Vue.component(component.name, component);
  });
};

//  全局引用可自动安装
if (typeof window !== "undefined" && window.Vue) {
  install(window.Vue);
}

export default {
  install,
  ...components,
};

export { AMap, AInfoWindow };
