### 简介

腾讯云 Web 信令 SDK，以腾讯云即时通信 IM 为基础，在实时音视频场景用于发送和接收信令消息，如发起单人、多人通话等。接入前，您需要在 [云通信控制台](https://console.cloud.tencent.com/avc) 中创建一个云通信应用，并取得 SDKAppID，并了解腾讯云实时音视频 [TRTC](https://cloud.tencent.com/product/trtc/developer)。

### api list

| api | 含义 |
| :--- | :--- |
| new TSignaling(options) | 初始化信令 SDK |
| setLogLevel(level) | 设置日志级别 |
| on(eventName, handler, context) | 监听事件 |
| login(options) | 登录 |
| logout() | 登出 |
| joinGroup(groupID) | 加群 |
| quitGroup(groupID) | 退群 |
| sendTextMessage(options) | 发送文本消息 |
| sendCustomMessage(options) | 发送自定义消息 |
| invite(options) | 邀请单个人 |
| inviteInGroup(options) | 群内邀请某些人 |
| cancel(options) | 邀请发起者取消邀请 |
| accept(options) | 被邀请人接受邀请 |
| reject(options) | 被邀请人拒绝邀请 |

### event list
| event | 含义 |
| :--- | :--- |
| TSignaling.EVENT.NEW_INVITATION_RECEIVED | 收到新的邀请 |
| TSignaling.EVENT.INVITEE_ACCEPTED | 被邀请人接受了邀请 |
| TSignaling.EVENT.INVITEE_REJECTED | 被邀请人拒绝了邀请 |
| TSignaling.EVENT.INVITATION_CANCELLED | 邀请被发起者取消 |
| TSignaling.EVENT.INVITATION_TIMEOUT | 邀请超时 |
| TSignaling.EVENT.SDK_READY | sdk ready,可以发信令消息 |
| TSignaling.EVENT.SDK_NOT_READY | sdk not ready,不可以发信令消息 |
| TSignaling.EVENT.TEXT_MESSAGE_RECEIVED | 收到普通文本消息 |
| TSignaling.EVENT.CUSTOM_MESSAGE_RECEIVED | 收到普通自定义消息 |
| TSignaling.EVENT.REMOTE_USER_JOIN | 有远端用户加入群 |
| TSignaling.EVENT.REMOTE_USER_LEAVE | 有远端用户离开群
| TSignaling.EVENT.KICKED_OUT | 被腾讯云即时通信 IM 系统踢下线 |
| TSignaling.EVENT.NET_STATE_CHANGE | 用户网络发生变化 |

### type list

| type | 含义 |
| :-----| :----- |
| TSignaling.TYPES.MSG_PRIORITY_HIGH | 群消息高优先级。建议选择该优先级的消息类型：红包消息和礼物消息 |
| TSignaling.TYPES.MSG_PRIORITY_NORMAL | 群消息普通优先级。建议选择该优先级的消息类型：普通文本消息 |
| TSignaling.TYPES.MSG_PRIORITY_LOW | 群消息低优先级。建议选择该优先级的消息类型：点赞消息 |
| TSignaling.TYPES.MSG_PRIORITY_LOWEST | 群消息最低优先级。建议选择该优先级的消息类型：最不重要的消息 |
| TSignaling.TYPES.KICKED_OUT_MULT_ACCOUNT | Web 端实例同时在线个数超限被踢 |
| TSignaling.TYPES.KICKED_OUT_MULT_DEVICE | 多端登录超限被踢 |
| TSignaling.TYPES.KICKED_OUT_USERSIG_EXPIRED | userSig 过期被踢 |
| TSignaling.TYPES.NET_STATE_CONNECTED | 已接入网络 |
| TSignaling.TYPES.NET_STATE_CONNECTING | 连接中 |
| TSignaling.TYPES.NET_STATE_DISCONNECTED | 未接入网络 |
| TSignaling.TYPES.ENTER_ROOM_SUCCESS | 加入群成功 |
| TSignaling.TYPES.ALREADY_IN_ROOM | 已在群内 |

### 参考文档

- [腾讯云即时通信 IM](https://cloud.tencent.com/document/product/269/1498)
- [WebIM API](https://web.sdk.qcloud.com/im/doc/zh-cn/TIM.html)
- [腾讯实时音视频 TRTC](https://cloud.tencent.com/document/product/647/16788)
