/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.page.PageDiy;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.request.page.PageDiyEditNameRequest;
import com.zbkj.common.response.page.PageDiyResponse;
import com.zbkj.service.dao.page.PageDiyDao;
import com.zbkj.service.service.PageDiyService;
import com.zbkj.service.service.SystemConfigService;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PageDiyServiceImpl
extends ServiceImpl<PageDiyDao, PageDiy>
implements PageDiyService {
    @Resource
    private PageDiyDao dao;
    @Autowired
    private SystemConfigService systemConfigService;

    @Override
    public List<PageDiy> getList(String name, PageParamRequest pageParamRequest) {
        PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery();
        lambdaQueryWrapper.select(PageDiy.class, i -> !i.getColumn().equals("value"));
        lambdaQueryWrapper.eq(PageDiy::getIsDefault, (Object)0);
        if (ObjectUtil.isNotEmpty((Object)name)) {
            lambdaQueryWrapper.like(PageDiy::getName, (Object)URLUtil.decode((String)name));
        }
        lambdaQueryWrapper.orderByDesc(PageDiy::getAddTime);
        List pageDiys = this.dao.selectList((Wrapper)lambdaQueryWrapper);
        if (pageParamRequest.getPage() == 1) {
            pageDiys.add(0, this.getDiyPageHome());
        }
        return pageDiys;
    }

    @Override
    public PageDiy savePageDiy(PageDiy pageDiy) {
        String adminApiPath = this.systemConfigService.getValueByKey("api_url");
        if (StrUtil.isBlank((CharSequence)adminApiPath)) {
            throw new CrmebException("\u5e94\u7528\u8bbe\u7f6e\u4e2d \u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u6570\u636e\u914d\u7f6e \u6216\u8005 \u652f\u4ed8\u56de\u8c03\u5730\u5740\u4ee5\u53ca\u7f51\u7ad9\u5730\u5740 \u914d\u7f6e\u4e0d\u5168");
        }
        DocumentContext jsonContext = JsonPath.parse((String)pageDiy.getValue());
        jsonContext.delete("$..*[?(@ == '" + adminApiPath + "')]", new Predicate[0]);
        pageDiy.setValue(jsonContext.jsonString());
        this.save(pageDiy);
        return pageDiy;
    }

    @Override
    public Boolean editPageDiyName(PageDiyEditNameRequest pageDiyEditNameRequest) {
        PageDiy pageDiyForUpdate = new PageDiy();
        pageDiyForUpdate.setId(pageDiyEditNameRequest.getId());
        pageDiyForUpdate.setName(pageDiyEditNameRequest.getName());
        return this.dao.updateById(pageDiyForUpdate) > 0;
    }

    @Override
    public Boolean setDiyPageHome(Integer diyId) {
        PageDiy pageDiy = (PageDiy)this.dao.selectById(diyId);
        if (ObjectUtil.isNull((Object)pageDiy)) {
            throw new CrmebException("\u5f53\u524dDIY\u6a21\u7248\u4e0d\u5b58\u5728");
        }
        LambdaQueryWrapper queryWaiteResetDefaultTemp = Wrappers.lambdaQuery();
        queryWaiteResetDefaultTemp.eq(PageDiy::getIsDefault, (Object)1);
        List currentWaitResetPageHome = this.dao.selectList((Wrapper)queryWaiteResetDefaultTemp);
        List currentTempByReset = currentWaitResetPageHome.stream().map(homeTemp -> homeTemp.setIsDefault(Integer.valueOf(0))).collect(Collectors.toList());
        this.saveOrUpdateBatch(currentTempByReset);
        pageDiy.setIsDefault(Integer.valueOf(1));
        return this.dao.updateById(pageDiy) > 0;
    }

    @Override
    public PageDiy getDiyPageHome() {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(PageDiy::getIsDefault, (Object)1);
        queryWrapper.select(PageDiy.class, i -> !i.getColumn().equals("value"));
        List currentWaitResetPageHome = this.dao.selectList((Wrapper)queryWrapper);
        if (ObjectUtil.isNull((Object)currentWaitResetPageHome) || currentWaitResetPageHome.size() != 1) {
            throw new CrmebException("\u9996\u9875\u6a21\u7248\u8bbe\u7f6e\u4e0d\u6b63\u786e\uff01");
        }
        return (PageDiy)currentWaitResetPageHome.get(0);
    }

    @Override
    public PageDiyResponse getDiyPageByPageId(Integer id) {
        PageDiy pageDiy;
        if (0 == id) {
            LambdaQueryWrapper getHomeDefault = Wrappers.lambdaQuery();
            getHomeDefault.eq(PageDiy::getIsDefault, (Object)1);
            pageDiy = (PageDiy)this.getOne((Wrapper)getHomeDefault);
        } else {
            pageDiy = (PageDiy)this.getById(id);
        }
        if (ObjectUtil.isNull((Object)pageDiy)) {
            throw new CrmebException("\u672a\u627e\u5230\u5bf9\u5e94\u6a21\u7248\u4fe1\u606f");
        }
        DocumentContext jsonContext = JsonPath.parse((String)pageDiy.getValue());
        jsonContext.delete("$..*[?(@.name == 'goodList')].itemStyle.list", new Predicate[0]);
        jsonContext.delete("$..*[?(@.name == 'goodList')].tabConfig.list", new Predicate[0]);
        jsonContext.delete("$..*[?(@.name == 'goodList')].typeConfig.list", new Predicate[0]);
        jsonContext.delete("$..*[?(@.name == 'goodList')].goodsSort.list", new Predicate[0]);
        jsonContext.delete("$..*[?(@.name == 'goodList')].goodsList.list[*].attrValue", new Predicate[0]);
        jsonContext.delete("$..*[?(@.name == 'homeTab')].activeValueBrand", new Predicate[0]);
        jsonContext.delete("$..*[?(@.name == 'homeTab')].goodsList", new Predicate[0]);
        jsonContext.delete("$..*[?(@.name == 'homeTab')].selectConfig", new Predicate[0]);
        jsonContext.delete("$..*[?(@.name == 'homeTab')].productList..*.goods[*].attrValue", new Predicate[0]);
        PageDiyResponse response = new PageDiyResponse();
        BeanUtils.copyProperties((Object)pageDiy, (Object)response);
        response.setValue(JSON.parseObject((String)jsonContext.jsonString()));
        return response;
    }
}

