/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.constants.CouponConstants;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.admin.SystemAdmin;
import com.zbkj.common.model.coupon.Coupon;
import com.zbkj.common.model.coupon.CouponProduct;
import com.zbkj.common.model.coupon.CouponUser;
import com.zbkj.common.model.merchant.Merchant;
import com.zbkj.common.model.product.ProductBrand;
import com.zbkj.common.model.product.ProductCategory;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.CommonSearchRequest;
import com.zbkj.common.request.CouponAddRequest;
import com.zbkj.common.request.CouponBatchSendRequest;
import com.zbkj.common.request.CouponCenterSearchRequest;
import com.zbkj.common.request.CouponDeleteRequest;
import com.zbkj.common.request.CouponFrontSearchRequest;
import com.zbkj.common.request.CouponProductJoinRequest;
import com.zbkj.common.request.CouponRequest;
import com.zbkj.common.request.CouponSearchRequest;
import com.zbkj.common.request.CouponUpdateRequest;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.response.CouponAdminDetailResponse;
import com.zbkj.common.response.CouponCenterPageResponse;
import com.zbkj.common.response.CouponFrontResponse;
import com.zbkj.common.response.CouponInfoResponse;
import com.zbkj.common.response.CouponPageResponse;
import com.zbkj.common.response.ProductCouponUseResponse;
import com.zbkj.common.utils.CrmebDateUtil;
import com.zbkj.common.utils.CrmebUtil;
import com.zbkj.common.utils.SecurityUtil;
import com.zbkj.common.vo.CouponSimpleVo;
import com.zbkj.common.vo.SimpleProductVo;
import com.zbkj.service.dao.CouponDao;
import com.zbkj.service.service.CouponProductService;
import com.zbkj.service.service.CouponService;
import com.zbkj.service.service.CouponUserService;
import com.zbkj.service.service.MerchantService;
import com.zbkj.service.service.ProductBrandService;
import com.zbkj.service.service.ProductCategoryService;
import com.zbkj.service.service.ProductService;
import com.zbkj.service.service.SystemConfigService;
import com.zbkj.service.service.UserService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class CouponServiceImpl
extends ServiceImpl<CouponDao, Coupon>
implements CouponService {
    private static final Logger log = LogManager.getLogger(CouponServiceImpl.class);
    @Resource
    private CouponDao dao;
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private CouponProductService couponProductService;
    @Autowired
    private ProductService productService;
    @Autowired
    private CouponUserService couponUserService;
    @Autowired
    private UserService userService;
    @Autowired
    private ProductCategoryService productCategoryService;
    @Autowired
    private ProductBrandService productBrandService;
    @Autowired
    private MerchantService merchantService;
    @Autowired
    private SystemConfigService systemConfigService;

    @Override
    public Boolean create(CouponRequest request) {
        if (request.getIsLimited().booleanValue() && (ObjectUtil.isNull((Object)request.getTotal()) || request.getTotal().equals(0))) {
            throw new CrmebException("\u8bf7\u8f93\u5165\u9650\u91cf\u6570\u91cf\uff01");
        }
        if (request.getCategory().equals(CouponConstants.COUPON_CATEGORY_PRODUCT) && StrUtil.isBlank((CharSequence)request.getProductIds())) {
            throw new CrmebException("\u8bf7\u9009\u62e9\u5546\u54c1");
        }
        if (request.getIsTimeReceive().booleanValue()) {
            if (ObjectUtil.isNull((Object)request.getReceiveStartTime()) || ObjectUtil.isNull((Object)request.getReceiveEndTime())) {
                throw new CrmebException("\u8bf7\u9009\u62e9\u9886\u53d6\u65f6\u95f4\u8303\u56f4\uff01");
            }
            int compareDate = CrmebDateUtil.compareDate((String)CrmebDateUtil.dateToStr((Date)request.getReceiveStartTime(), (String)"yyyy-MM-dd HH:mm:ss"), (String)CrmebDateUtil.dateToStr((Date)request.getReceiveEndTime(), (String)"yyyy-MM-dd HH:mm:ss"), (String)"yyyy-MM-dd HH:mm:ss");
            if (compareDate > -1) {
                throw new CrmebException("\u8bf7\u9009\u62e9\u6b63\u786e\u7684\u9886\u53d6\u65f6\u95f4\u8303\u56f4\uff01");
            }
        }
        if (!request.getIsFixedTime().booleanValue() && (ObjectUtil.isNull((Object)request.getDay()) || request.getDay().equals(0))) {
            throw new CrmebException("\u8bf7\u8f93\u5165\u5929\u6570\uff01");
        }
        Coupon coupon = new Coupon();
        BeanUtils.copyProperties((Object)request, (Object)coupon);
        coupon.setLastTotal(coupon.getTotal());
        coupon.setPublisher(CouponConstants.COUPON_PUBLISHER_MERCHANT);
        coupon.setCouponType(CouponConstants.COUPON_TYPE_SATISFY);
        if (StrUtil.isNotBlank((CharSequence)request.getProductIds())) {
            coupon.setLinkedData(request.getProductIds());
        }
        if (!request.getIsFixedTime().booleanValue()) {
            coupon.setUseStartTime(null);
            coupon.setUseEndTime(null);
        }
        SystemAdmin systemAdmin = SecurityUtil.getLoginUserVo().getUser();
        coupon.setMerId(systemAdmin.getMerId());
        ArrayList cpList = new ArrayList();
        if (request.getCategory().equals(CouponConstants.COUPON_CATEGORY_PRODUCT)) {
            String productIds = request.getProductIds();
            List productIdList = CrmebUtil.stringToArray((String)productIds);
            productIdList.forEach(pid -> {
                CouponProduct couponProduct = new CouponProduct();
                couponProduct.setPid(pid);
                cpList.add(couponProduct);
            });
        }
        return (Boolean)this.transactionTemplate.execute(e -> {
            this.save(coupon);
            if (CollUtil.isNotEmpty((Collection)cpList)) {
                cpList.forEach(cp -> cp.setCid(coupon.getId()));
                this.couponProductService.saveBatch(cpList, 100);
            }
            return Boolean.TRUE;
        });
    }

    @Override
    public Coupon getInfoException(Integer id) {
        Coupon coupon = (Coupon)this.getById(id);
        if (ObjectUtil.isNull((Object)coupon) || coupon.getIsDel().booleanValue()) {
            throw new CrmebException("\u4f18\u60e0\u5238\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
        }
        return coupon;
    }

    @Override
    public CouponInfoResponse info(Integer id) {
        SystemAdmin systemAdmin = SecurityUtil.getLoginUserVo().getUser();
        Coupon coupon = this.getByIdAndMerIdException(id, systemAdmin.getMerId());
        List<SimpleProductVo> productList = null;
        if (coupon.getCategory().equals(CouponConstants.COUPON_CATEGORY_PRODUCT)) {
            List<CouponProduct> cpList = this.couponProductService.findByCid(coupon.getId());
            List<Integer> primaryIdList = cpList.stream().map(CouponProduct::getPid).collect(Collectors.toList());
            productList = this.productService.getSimpleListInIds(primaryIdList);
        }
        CouponInfoResponse infoResponse = new CouponInfoResponse();
        BeanUtils.copyProperties((Object)coupon, (Object)infoResponse);
        if (CollUtil.isNotEmpty(productList)) {
            infoResponse.setProductList(productList);
        }
        return infoResponse;
    }

    private Coupon getByIdAndMerIdException(Integer id, Integer merId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(Coupon::getId, (Object)id);
        lqw.eq(Coupon::getMerId, (Object)merId);
        lqw.eq(Coupon::getIsDel, (Object)false);
        lqw.last(" limit 1");
        Coupon Coupon2 = (Coupon)this.dao.selectOne((Wrapper)lqw);
        if (ObjectUtil.isNull((Object)Coupon2)) {
            throw new CrmebException("\u4f18\u60e0\u5238\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
        }
        return Coupon2;
    }

    @Override
    public Boolean deduction(Integer id, Integer num, Boolean isLimited) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        if (isLimited.booleanValue()) {
            updateWrapper.setSql(StrUtil.format((CharSequence)"last_total = last_total - {}", (Object[])new Object[]{num}));
            updateWrapper.last(StrUtil.format((CharSequence)" and (last_total - {} >= 0)", (Object[])new Object[]{num}));
        } else {
            updateWrapper.setSql(StrUtil.format((CharSequence)"last_total = last_total + {}", (Object[])new Object[]{num}));
        }
        updateWrapper.eq((Object)"id", (Object)id);
        return this.update((Wrapper)updateWrapper);
    }

    @Override
    public Boolean delete(Integer id) {
        SystemAdmin systemAdmin = SecurityUtil.getLoginUserVo().getUser();
        Coupon coupon = this.getByIdAndMerIdException(id, systemAdmin.getMerId());
        coupon.setIsDel(Boolean.valueOf(true));
        return (Boolean)this.transactionTemplate.execute(e -> {
            this.updateById(coupon);
            this.couponProductService.deleteByCid(coupon.getId());
            return Boolean.TRUE;
        });
    }

    @Override
    public PageInfo<CouponFrontResponse> getH5List(CouponFrontSearchRequest request, PageParamRequest pageParamRequest) {
        if (ObjectUtil.isNull((Object)request.getMerId()) && ObjectUtil.isNull((Object)request.getProductId())) {
            throw new CrmebException("\u5546\u6237ID\u4e0e\u5546\u54c1ID\u4e0d\u80fd\u90fd\u4e3a\u7a7a");
        }
        PageInfo<Coupon> pageInfo = this.getH5ListBySearch(request.getCategory(), request.getMerId(), request.getProductId(), pageParamRequest);
        List list = pageInfo.getList();
        if (ObjectUtil.isNull((Object)list)) {
            return CommonPage.copyPageInfo(pageInfo, (List)CollUtil.newArrayList((Object[])new CouponFrontResponse[0]));
        }
        Integer userId = this.userService.getUserId();
        ArrayList<CouponFrontResponse> CouponFrontResponseArrayList = new ArrayList<CouponFrontResponse>();
        for (Coupon coupon : list) {
            CouponUser couponUser;
            CouponFrontResponse response = new CouponFrontResponse();
            BeanUtils.copyProperties((Object)coupon, (Object)response);
            if (userId > 0 && ObjectUtil.isNotNull((Object)(couponUser = this.couponUserService.getLastByCouponIdAndUid(coupon.getId(), userId)))) {
                response.setIsUse(Boolean.valueOf(true));
                if (coupon.getIsRepeated().booleanValue() && !couponUser.getStatus().equals(CouponConstants.STORE_COUPON_USER_STATUS_USABLE)) {
                    response.setIsUse(Boolean.valueOf(false));
                }
            }
            response.setUseStartTimeStr(CrmebDateUtil.dateToStr((Date)coupon.getUseStartTime(), (String)"yyyy-MM-dd"));
            response.setUseEndTimeStr(CrmebDateUtil.dateToStr((Date)coupon.getUseEndTime(), (String)"yyyy-MM-dd"));
            CouponFrontResponseArrayList.add(response);
        }
        return CommonPage.copyPageInfo(pageInfo, CouponFrontResponseArrayList);
    }

    @Override
    public Boolean updateStatus(Integer id) {
        SystemAdmin systemAdmin = SecurityUtil.getLoginUserVo().getUser();
        Coupon coupon = this.getByIdAndMerIdException(id, systemAdmin.getMerId());
        Coupon tempCoupon = new Coupon();
        tempCoupon.setId(id);
        tempCoupon.setStatus(Boolean.valueOf(coupon.getStatus() == false));
        return this.updateById(tempCoupon);
    }

    @Override
    public PageInfo<Coupon> getMerchantPageList(CouponSearchRequest request) {
        SystemAdmin systemAdmin = SecurityUtil.getLoginUserVo().getUser();
        Page page = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.eq(Coupon::getMerId, (Object)systemAdmin.getMerId());
        lqw.eq(Coupon::getIsDel, (Object)false);
        if (ObjectUtil.isNotNull((Object)request.getCategory())) {
            lqw.eq(Coupon::getCategory, (Object)request.getCategory());
        }
        if (ObjectUtil.isNotNull((Object)request.getReceiveType())) {
            lqw.eq(Coupon::getReceiveType, (Object)request.getReceiveType());
        }
        if (ObjectUtil.isNotNull((Object)request.getStatus())) {
            lqw.eq(Coupon::getStatus, (Object)request.getStatus());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getName())) {
            String name = URLUtil.decode((String)request.getName());
            lqw.like(Coupon::getName, (Object)name);
        }
        ((LambdaQueryWrapper)lqw.orderByDesc(Coupon::getSort)).orderByDesc(Coupon::getId);
        List couponList = this.dao.selectList((Wrapper)lqw);
        return CommonPage.copyPageInfo((Page)page, (List)couponList);
    }

    @Override
    public List<ProductCouponUseResponse> getProductUsableList() {
        SystemAdmin systemAdmin = SecurityUtil.getLoginUserVo().getUser();
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.select(new SFunction[]{Coupon::getId, Coupon::getName, Coupon::getMoney, Coupon::getMinPrice, Coupon::getIsLimited, Coupon::getLastTotal, Coupon::getIsFixedTime, Coupon::getUseStartTime, Coupon::getUseEndTime, Coupon::getDay});
        lqw.eq(Coupon::getMerId, (Object)systemAdmin.getMerId());
        lqw.eq(Coupon::getIsDel, (Object)false);
        lqw.eq(Coupon::getReceiveType, (Object)CouponConstants.COUPON_RECEIVE_TYPE_PAY_PRODUCT);
        lqw.eq(Coupon::getStatus, (Object)1);
        ((LambdaQueryWrapper)lqw.orderByDesc(Coupon::getSort)).orderByDesc(Coupon::getId);
        List couponList = this.dao.selectList((Wrapper)lqw);
        if (CollUtil.isEmpty((Collection)couponList)) {
            return CollUtil.newArrayList((Object[])new ProductCouponUseResponse[0]);
        }
        return couponList.stream().map(c -> {
            ProductCouponUseResponse response = new ProductCouponUseResponse();
            BeanUtils.copyProperties((Object)c, (Object)response);
            return response;
        }).collect(Collectors.toList());
    }

    @Override
    public Boolean couponProductJoinEdit(CouponProductJoinRequest request) {
        SystemAdmin systemAdmin = SecurityUtil.getLoginUserVo().getUser();
        Coupon coupon = this.getByIdAndMerIdException(request.getId(), systemAdmin.getMerId());
        if (!coupon.getCategory().equals(CouponConstants.COUPON_CATEGORY_PRODUCT)) {
            throw new CrmebException("\u4f18\u60e0\u5238\u4e0d\u662f\u5546\u54c1\u5238");
        }
        List productIdList = CrmebUtil.stringToArray((String)request.getProductIds());
        List cpList = productIdList.stream().map(pid -> {
            CouponProduct couponProduct = new CouponProduct();
            couponProduct.setPid(pid);
            couponProduct.setCid(coupon.getId());
            return couponProduct;
        }).collect(Collectors.toList());
        coupon.setLinkedData(request.getProductIds());
        return (Boolean)this.transactionTemplate.execute(e -> {
            this.updateById(coupon);
            this.couponProductService.deleteByCid(coupon.getId());
            this.couponProductService.saveBatch(cpList, 100);
            return Boolean.TRUE;
        });
    }

    @Override
    public List<CouponSimpleVo> findSimpleListByIdList(List<Integer> idList) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{Coupon::getId, Coupon::getName});
        lqw.in(Coupon::getId, idList);
        lqw.eq(Coupon::getIsDel, (Object)false);
        List couponList = this.dao.selectList((Wrapper)lqw);
        return couponList.stream().map(coupon -> {
            CouponSimpleVo simpleVo = new CouponSimpleVo();
            simpleVo.setId(coupon.getId());
            simpleVo.setName(coupon.getName());
            return simpleVo;
        }).collect(Collectors.toList());
    }

    @Override
    public Boolean platformAdd(CouponAddRequest request) {
        this.validateParams(request);
        Coupon coupon = new Coupon();
        BeanUtils.copyProperties((Object)request, (Object)coupon);
        coupon.setLastTotal(coupon.getTotal());
        coupon.setPublisher(CouponConstants.COUPON_PUBLISHER_PLATFORM);
        coupon.setCouponType(CouponConstants.COUPON_TYPE_SATISFY);
        coupon.setMerId(Integer.valueOf(0));
        ArrayList cpList = new ArrayList();
        if (request.getCategory().equals(CouponConstants.COUPON_CATEGORY_PRODUCT)) {
            String productIds = request.getLinkedData();
            List productIdList = CrmebUtil.stringToArray((String)productIds);
            productIdList.forEach(pid -> {
                CouponProduct couponProduct = new CouponProduct();
                couponProduct.setPid(pid);
                cpList.add(couponProduct);
            });
        }
        return (Boolean)this.transactionTemplate.execute(e -> {
            this.save(coupon);
            if (CollUtil.isNotEmpty((Collection)cpList)) {
                cpList.forEach(cp -> cp.setCid(coupon.getId()));
                this.couponProductService.saveBatch(cpList, 100);
            }
            return Boolean.TRUE;
        });
    }

    @Override
    public Boolean platformDelete(CouponDeleteRequest request) {
        Coupon coupon = (Coupon)this.getById(request.getId());
        if (ObjectUtil.isNull((Object)coupon) || coupon.getIsDel().booleanValue()) {
            throw new CrmebException("\u4f18\u60e0\u5238\u5df2\u5220\u9664");
        }
        if (coupon.getMerId() > 0) {
            throw new CrmebException("\u65e0\u6cd5\u64cd\u4f5c\u5546\u6237\u4f18\u60e0\u5238");
        }
        coupon.setIsDel(Boolean.valueOf(true));
        return (Boolean)this.transactionTemplate.execute(e -> {
            this.updateById(coupon);
            if (request.getLoseEfficacyStatus().equals(1)) {
                this.couponUserService.loseEfficacyByCouponId(coupon.getId());
            }
            return Boolean.TRUE;
        });
    }

    @Override
    public Boolean switchById(Integer id) {
        Coupon coupon = (Coupon)this.getById(id);
        if (ObjectUtil.isNull((Object)coupon) || coupon.getIsDel().booleanValue()) {
            throw new CrmebException("\u4f18\u60e0\u5238\u5df2\u5220\u9664");
        }
        coupon.setStatus(Boolean.valueOf(coupon.getStatus() == false));
        return this.updateById(coupon);
    }

    @Override
    public CouponAdminDetailResponse getPlatformDetail(Integer id) {
        Coupon coupon = (Coupon)this.getById(id);
        if (ObjectUtil.isNull((Object)coupon) || coupon.getIsDel().booleanValue()) {
            throw new CrmebException("\u4f18\u60e0\u5238\u5df2\u5220\u9664");
        }
        CouponAdminDetailResponse response = new CouponAdminDetailResponse();
        BeanUtils.copyProperties((Object)coupon, (Object)response);
        response.setIssuedNum(Integer.valueOf(0));
        if (coupon.getIsLimited().booleanValue()) {
            response.setIssuedNum(Integer.valueOf(coupon.getTotal() - coupon.getLastTotal()));
        } else {
            response.setIssuedNum(coupon.getLastTotal());
        }
        response.setUsedNum(this.couponUserService.getUsedNumByCouponId(coupon.getId()));
        switch (coupon.getCategory()) {
            case 1: {
                break;
            }
            case 2: {
                List<CouponProduct> cpList = this.couponProductService.findByCid(coupon.getId());
                List<Integer> primaryIdList = cpList.stream().map(CouponProduct::getPid).collect(Collectors.toList());
                response.setProductList(this.productService.getSimpleListInIds(primaryIdList));
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                String productCategoryIds = coupon.getLinkedData();
                response.setLinkedDataStr(this.productCategoryService.getNameStrByIds(productCategoryIds));
                break;
            }
            case 5: {
                String brandId = coupon.getLinkedData();
                ProductBrand brand = (ProductBrand)this.productBrandService.getById(Integer.valueOf(brandId));
                response.setLinkedDataStr(brand.getName());
                break;
            }
            case 6: {
                String merIds = coupon.getLinkedData();
                List merIdList = CrmebUtil.stringToArray((String)merIds);
                Map<Integer, Merchant> merchantMap = this.merchantService.getMapByIdList(merIdList);
                ArrayList merchantList = CollUtil.newArrayList((Object[])new Merchant[0]);
                merchantList.addAll(merchantMap.values());
                response.setMerchantList((List)merchantList);
            }
        }
        return response;
    }

    @Override
    public PageInfo<CouponPageResponse> getPlatformPageList(CouponSearchRequest request) {
        Page page = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.eq(Coupon::getMerId, (Object)0);
        lqw.eq(Coupon::getIsDel, (Object)false);
        if (ObjectUtil.isNotNull((Object)request.getCategory())) {
            lqw.eq(Coupon::getCategory, (Object)request.getCategory());
        }
        if (ObjectUtil.isNotNull((Object)request.getReceiveType())) {
            lqw.eq(Coupon::getReceiveType, (Object)request.getReceiveType());
        }
        if (ObjectUtil.isNotNull((Object)request.getStatus())) {
            lqw.eq(Coupon::getStatus, (Object)request.getStatus());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getName())) {
            String name = URLUtil.decode((String)request.getName());
            lqw.like(Coupon::getName, (Object)name);
        }
        lqw.orderByDesc(Coupon::getCreateTime);
        List couponList = this.dao.selectList((Wrapper)lqw);
        if (CollUtil.isEmpty((Collection)couponList)) {
            return CommonPage.copyPageInfo((Page)page, new ArrayList());
        }
        List responseList = couponList.stream().map(c -> {
            CouponPageResponse response = new CouponPageResponse();
            BeanUtils.copyProperties((Object)c, (Object)response);
            if (c.getIsLimited().booleanValue()) {
                response.setIssuedNum(Integer.valueOf(c.getTotal() - c.getLastTotal()));
            } else {
                response.setIssuedNum(c.getLastTotal());
            }
            response.setUsedNum(this.couponUserService.getUsedNumByCouponId(c.getId()));
            return response;
        }).collect(Collectors.toList());
        return CommonPage.copyPageInfo((Page)page, responseList);
    }

    @Override
    public Boolean platformBatchSend(CouponBatchSendRequest request) {
        Coupon coupon = (Coupon)this.getById(request.getCouponId());
        if (ObjectUtil.isNull((Object)coupon) || coupon.getIsDel().booleanValue()) {
            throw new CrmebException("\u4f18\u60e0\u5238\u5df2\u5220\u9664");
        }
        if (coupon.getMerId() > 0 || coupon.getPublisher().equals(CouponConstants.COUPON_PUBLISHER_MERCHANT)) {
            throw new CrmebException("\u65e0\u6cd5\u64cd\u4f5c\u5546\u6237\u4f18\u60e0\u5238");
        }
        if (!coupon.getReceiveType().equals(CouponConstants.COUPON_RECEIVE_TYPE_PLAT_SEND)) {
            throw new CrmebException("\u5e73\u53f0\u6d3b\u52a8\u53d1\u653e\u7c7b\u7684\u4f18\u60e0\u5238\u65b9\u53ef\u53d1\u9001");
        }
        if (coupon.getIsLimited().booleanValue() && coupon.getLastTotal() < request.getUidList().size()) {
            throw new CrmebException("\u53d1\u9001\u5931\u8d25\uff0c\u4f18\u60e0\u5238\u6570\u91cf\u4e0d\u8db3\uff01");
        }
        DateTime nowDate = DateUtil.date();
        if (coupon.getIsTimeReceive().booleanValue() && nowDate.compareTo(coupon.getReceiveEndTime()) > 0) {
            throw new CrmebException("\u4f18\u60e0\u5238\u53ef\u9886\u53d6\u65f6\u95f4\u5df2\u8fc7");
        }
        if (coupon.getIsFixedTime().booleanValue() && nowDate.compareTo(coupon.getUseEndTime()) > 0) {
            throw new CrmebException("\u53d1\u9001\u5931\u8d25\uff0c\u4f18\u60e0\u5238\u4f7f\u7528\u6709\u6548\u671f\u5df2\u8fc7\uff01");
        }
        List uidList = request.getUidList();
        if (!coupon.getIsRepeated().booleanValue()) {
            List<CouponUser> couponUserList = this.couponUserService.findByCouponIdAndUidList(coupon.getId(), uidList);
            couponUserList.forEach(cu -> {
                if (uidList.contains(cu.getUid())) {
                    uidList.removeIf(e -> e.equals(cu.getUid()));
                }
            });
            if (CollUtil.isEmpty((Collection)uidList)) {
                return Boolean.TRUE;
            }
        }
        if (!coupon.getIsFixedTime().booleanValue()) {
            String endTime = CrmebDateUtil.addDay((String)CrmebDateUtil.nowDate((String)"yyyy-MM-dd HH:mm:ss"), (int)coupon.getDay(), (String)"yyyy-MM-dd HH:mm:ss");
            coupon.setUseEndTime(CrmebDateUtil.strToDate((String)endTime, (String)"yyyy-MM-dd HH:mm:ss"));
            coupon.setUseStartTime(CrmebDateUtil.nowDateTimeReturnDate((String)"yyyy-MM-dd HH:mm:ss"));
        }
        List couponUsers = uidList.stream().map(uid -> {
            CouponUser couponUser = new CouponUser();
            couponUser.setCouponId(coupon.getId());
            couponUser.setUid(uid);
            couponUser.setMerId(Integer.valueOf(0));
            couponUser.setName(coupon.getName());
            couponUser.setPublisher(coupon.getPublisher());
            couponUser.setCategory(coupon.getCategory());
            couponUser.setReceiveType(coupon.getReceiveType());
            couponUser.setCouponType(coupon.getCouponType());
            couponUser.setMoney(coupon.getMoney());
            couponUser.setDiscount(coupon.getDiscount());
            couponUser.setMinPrice(coupon.getMinPrice());
            couponUser.setStatus(CouponConstants.STORE_COUPON_USER_STATUS_USABLE);
            if (!coupon.getIsFixedTime().booleanValue()) {
                String endTime = CrmebDateUtil.addDay((String)CrmebDateUtil.nowDate((String)"yyyy-MM-dd HH:mm:ss"), (int)coupon.getDay(), (String)"yyyy-MM-dd HH:mm:ss");
                couponUser.setStartTime(CrmebDateUtil.nowDateTimeReturnDate((String)"yyyy-MM-dd HH:mm:ss"));
                couponUser.setEndTime(CrmebDateUtil.strToDate((String)endTime, (String)"yyyy-MM-dd HH:mm:ss"));
            } else {
                couponUser.setStartTime(coupon.getUseStartTime());
                couponUser.setEndTime(coupon.getUseEndTime());
            }
            return couponUser;
        }).collect(Collectors.toList());
        return (Boolean)this.transactionTemplate.execute(e -> {
            Boolean deduction = this.deduction(coupon.getId(), uidList.size(), coupon.getIsLimited());
            if (!deduction.booleanValue()) {
                e.setRollbackOnly();
                return Boolean.FALSE;
            }
            this.couponUserService.saveBatch(couponUsers, 100);
            return Boolean.TRUE;
        });
    }

    @Override
    public PageInfo<Coupon> getPlatformCanSendList(CommonSearchRequest request) {
        Page page = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        String now = DateUtil.now();
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.eq(Coupon::getMerId, (Object)0);
        lqw.eq(Coupon::getIsDel, (Object)false);
        lqw.eq(Coupon::getPublisher, (Object)CouponConstants.COUPON_PUBLISHER_PLATFORM);
        lqw.eq(Coupon::getStatus, (Object)true);
        lqw.eq(Coupon::getReceiveType, (Object)CouponConstants.COUPON_RECEIVE_TYPE_PLAT_SEND);
        if (StrUtil.isNotBlank((CharSequence)request.getKeywords())) {
            String keywords = URLUtil.decode((String)request.getKeywords());
            lqw.like(Coupon::getName, (Object)keywords);
        }
        lqw.and(i -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)i.eq(Coupon::getIsLimited, (Object)0)).or(o -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)o.gt(Coupon::getLastTotal, (Object)0);
            });
        });
        lqw.and(i -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)i.eq(Coupon::getIsTimeReceive, (Object)0)).or(o -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)o.le(Coupon::getReceiveStartTime, (Object)now)).ge(Coupon::getReceiveEndTime, (Object)now);
            });
        });
        lqw.orderByDesc(Coupon::getCreateTime);
        List list = this.dao.selectList((Wrapper)lqw);
        return CommonPage.copyPageInfo((Page)page, (List)list);
    }

    private void validateParams(CouponAddRequest request) {
        String[] split;
        if (request.getIsLimited().booleanValue() && (ObjectUtil.isNull((Object)request.getTotal()) || request.getTotal().equals(0))) {
            throw new CrmebException("\u8bf7\u8f93\u5165\u9650\u91cf\u6570\u91cf\uff01");
        }
        if (request.getIsTimeReceive().booleanValue()) {
            if (ObjectUtil.isNull((Object)request.getReceiveStartTime()) || ObjectUtil.isNull((Object)request.getReceiveEndTime())) {
                throw new CrmebException("\u8bf7\u9009\u62e9\u9886\u53d6\u65f6\u95f4\u8303\u56f4\uff01");
            }
            int compareDate = CrmebDateUtil.compareDate((String)CrmebDateUtil.dateToStr((Date)request.getReceiveStartTime(), (String)"yyyy-MM-dd HH:mm:ss"), (String)CrmebDateUtil.dateToStr((Date)request.getReceiveEndTime(), (String)"yyyy-MM-dd HH:mm:ss"), (String)"yyyy-MM-dd HH:mm:ss");
            if (compareDate > -1) {
                throw new CrmebException("\u8bf7\u9009\u62e9\u6b63\u786e\u7684\u9886\u53d6\u65f6\u95f4\u8303\u56f4\uff01");
            }
        }
        if (!request.getIsFixedTime().booleanValue() && (ObjectUtil.isNull((Object)request.getDay()) || request.getDay().equals(0))) {
            throw new CrmebException("\u8bf7\u8f93\u5165\u5929\u6570\uff01");
        }
        if (!request.getCategory().equals(CouponConstants.COUPON_CATEGORY_UNIVERSAL) && StrUtil.isBlank((CharSequence)request.getLinkedData())) {
            throw new CrmebException("\u8bf7\u9009\u62e9\u5173\u8054\u6570\u636e");
        }
        if ((request.getCategory().equals(CouponConstants.COUPON_CATEGORY_PRODUCT_CATEGORY) || request.getCategory().equals(CouponConstants.COUPON_CATEGORY_BRAND)) && (split = request.getLinkedData().split(",")).length > 1) {
            throw new CrmebException("\u53ea\u80fd\u9009\u62e9\u4e00\u4e2a\u54c1\u7c7b\u6216\u54c1\u724c");
        }
    }

    @Override
    public List<Coupon> getCouponListForDiyPageHome(Integer limit) {
        return this.dao.getCouponListForDiyHomePage(limit);
    }

    private PageInfo<Coupon> getH5ListBySearch(Integer category, Integer merId, Integer productId, PageParamRequest pageParamRequest) {
        Date date = CrmebDateUtil.nowDateTime();
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (category > 0) {
            map.put("category", category);
        }
        map.put("merId", merId);
        map.put("productId", productId);
        map.put("date", date);
        Page page = PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        List<Coupon> couponList = this.dao.getH5ListBySearch(map);
        return CommonPage.copyPageInfo((Page)page, couponList);
    }

    @Override
    public PageInfo<CouponCenterPageResponse> getCouponCenter(CouponCenterSearchRequest request) {
        Integer userId = this.userService.getUserId();
        String now = DateUtil.now();
        Page page = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(Coupon::getPublisher, (Object)CouponConstants.COUPON_PUBLISHER_PLATFORM);
        lqw.eq(Coupon::getMerId, (Object)0);
        lqw.eq(Coupon::getReceiveType, (Object)CouponConstants.COUPON_RECEIVE_TYPE_MANUAL);
        if (ObjectUtil.isNull((Object)request.getCategory()) || request.getCategory() > 0) {
            lqw.eq(Coupon::getCategory, (Object)request.getCategory());
        }
        lqw.and(i -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)i.eq(Coupon::getIsTimeReceive, (Object)0)).or(o -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)o.le(Coupon::getReceiveStartTime, (Object)now)).ge(Coupon::getReceiveEndTime, (Object)now);
            });
        });
        lqw.eq(Coupon::getStatus, (Object)1);
        lqw.eq(Coupon::getIsDel, (Object)0);
        lqw.orderByDesc(Coupon::getCreateTime);
        List couponList = this.dao.selectList((Wrapper)lqw);
        ArrayList responseList = new ArrayList();
        couponList.forEach(coupon -> {
            CouponUser couponUser;
            CouponCenterPageResponse response = new CouponCenterPageResponse();
            BeanUtils.copyProperties((Object)coupon, (Object)response);
            List<Object> productVoList = new ArrayList();
            switch (coupon.getCategory()) {
                case 2: {
                    List<CouponProduct> couponProductList = this.couponProductService.findByCid(coupon.getId());
                    List<Integer> pidList = couponProductList.stream().map(CouponProduct::getPid).collect(Collectors.toList());
                    productVoList = this.productService.findCouponListLimit3(coupon.getCategory(), pidList, null, null);
                    break;
                }
                case 3: {
                    productVoList = this.productService.findCouponListLimit3(coupon.getCategory(), null, null, null);
                    break;
                }
                case 4: {
                    ProductCategory productCategory = (ProductCategory)this.productCategoryService.getById(Integer.valueOf(coupon.getLinkedData()));
                    ArrayList<Integer> pcIdList = new ArrayList<Integer>();
                    if (productCategory.getLevel().equals(3)) {
                        pcIdList.add(productCategory.getId());
                    } else {
                        List<Object> productCategoryList = new ArrayList();
                        if (productCategory.getLevel().equals(2)) {
                            productCategoryList = this.productCategoryService.findAllChildListByPid(productCategory.getId(), productCategory.getLevel());
                        }
                        if (productCategory.getLevel().equals(1)) {
                            productCategoryList = this.productCategoryService.getThirdCategoryByFirstId(productCategory.getId(), 0);
                        }
                        List collect = productCategoryList.stream().map(ProductCategory::getId).collect(Collectors.toList());
                        pcIdList.addAll(collect);
                    }
                    productVoList = this.productService.findCouponListLimit3(coupon.getCategory(), null, coupon.getLinkedData(), pcIdList);
                    response.setProductCategoryName(productCategory.getName());
                    break;
                }
                case 5: {
                    ProductBrand brand = (ProductBrand)this.productBrandService.getById(Integer.valueOf(coupon.getLinkedData()));
                    productVoList = this.productService.findCouponListLimit3(coupon.getCategory(), null, coupon.getLinkedData(), null);
                    response.setProductBrandName(brand.getName());
                    break;
                }
                case 6: {
                    productVoList = this.productService.findCouponListLimit3(coupon.getCategory(), null, coupon.getLinkedData(), null);
                }
            }
            response.setProductVoList(productVoList);
            if (userId > 0 && ObjectUtil.isNotNull((Object)(couponUser = this.couponUserService.getLastByCouponIdAndUid(coupon.getId(), userId)))) {
                response.setIsUserReceive(Boolean.valueOf(true));
                if (coupon.getIsRepeated().booleanValue() && !couponUser.getStatus().equals(CouponConstants.STORE_COUPON_USER_STATUS_USABLE)) {
                    response.setIsUserReceive(Boolean.valueOf(false));
                }
            }
            responseList.add(response);
        });
        return CommonPage.copyPageInfo((Page)page, responseList);
    }

    @Override
    public Boolean deleteByBrandId(Integer brandId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{Coupon::getId});
        lqw.eq(Coupon::getCategory, (Object)CouponConstants.COUPON_CATEGORY_BRAND);
        lqw.eq(Coupon::getLinkedData, (Object)brandId.toString());
        lqw.eq(Coupon::getIsDel, (Object)false);
        List couponList = this.dao.selectList((Wrapper)lqw);
        if (CollUtil.isEmpty((Collection)couponList)) {
            return Boolean.TRUE;
        }
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(Coupon::getIsDel, (Object)true);
        wrapper.eq(Coupon::getCategory, (Object)CouponConstants.COUPON_CATEGORY_BRAND);
        wrapper.eq(Coupon::getLinkedData, (Object)brandId.toString());
        return (Boolean)this.transactionTemplate.execute(e -> {
            this.update((Wrapper)wrapper);
            couponList.forEach(c -> this.couponUserService.loseEfficacyByCouponId(c.getId()));
            return Boolean.TRUE;
        });
    }

    @Override
    public Boolean deleteByProCategoryId(Integer proCategoryId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{Coupon::getId});
        lqw.eq(Coupon::getCategory, (Object)CouponConstants.COUPON_CATEGORY_PRODUCT_CATEGORY);
        lqw.eq(Coupon::getLinkedData, (Object)proCategoryId.toString());
        lqw.eq(Coupon::getIsDel, (Object)false);
        List couponList = this.dao.selectList((Wrapper)lqw);
        if (CollUtil.isEmpty((Collection)couponList)) {
            return Boolean.TRUE;
        }
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(Coupon::getIsDel, (Object)true);
        wrapper.eq(Coupon::getCategory, (Object)CouponConstants.COUPON_CATEGORY_PRODUCT_CATEGORY);
        wrapper.eq(Coupon::getLinkedData, (Object)proCategoryId.toString());
        return (Boolean)this.transactionTemplate.execute(e -> {
            this.update((Wrapper)wrapper);
            couponList.forEach(c -> this.couponUserService.loseEfficacyByCouponId(c.getId()));
            return Boolean.TRUE;
        });
    }

    @Override
    public Boolean edit(CouponUpdateRequest request) {
        String[] split;
        if (request.getIsLimited().booleanValue() && ObjectUtil.isNull((Object)request.getNum())) {
            throw new CrmebException("\u8bf7\u9009\u62e9\u6dfb\u52a0\u53d1\u653e\u6570\u91cf");
        }
        if (request.getIsFixedTime().booleanValue() && (ObjectUtil.isNull((Object)request.getUseEndTime()) || ObjectUtil.isNull((Object)request.getUseStartTime()))) {
            throw new CrmebException("\u8bf7\u9009\u62e9\u4f7f\u7528\u65f6\u95f4\u8303\u56f4");
        }
        if (!request.getIsFixedTime().booleanValue() && ObjectUtil.isNull((Object)request.getDay())) {
            throw new CrmebException("\u8bf7\u9009\u62e9\u4f7f\u7528\u5929\u6570");
        }
        Coupon coupon = (Coupon)this.getById(request.getId());
        if (ObjectUtil.isNull((Object)coupon)) {
            throw new CrmebException("\u4f18\u60e0\u5238\u4e0d\u5b58\u5728");
        }
        if (request.getIsLimited().booleanValue() && !coupon.getIsLimited().booleanValue()) {
            throw new CrmebException("\u4e0d\u9650\u91cf\u4f18\u60e0\u5238\u4e0d\u80fd\u6539\u4e3a\u9650\u91cf");
        }
        if (request.getIsTimeReceive().booleanValue() && !coupon.getIsTimeReceive().booleanValue()) {
            throw new CrmebException("\u9886\u53d6\u4e0d\u9650\u65f6\u4f18\u60e0\u5238\u4e0d\u80fd\u6539\u4e3a\u9650\u65f6");
        }
        if (request.getIsTimeReceive().booleanValue() && coupon.getIsTimeReceive().booleanValue() && request.getReceiveEndTime().compareTo(coupon.getReceiveEndTime()) < 0) {
            throw new CrmebException("\u9886\u53d6\u65f6\u95f4\u53ea\u80fd\u5f80\u957f\u5ef6\u671f");
        }
        if (!coupon.getCategory().equals(CouponConstants.COUPON_CATEGORY_UNIVERSAL) && StrUtil.isBlank((CharSequence)request.getLinkedData())) {
            throw new CrmebException("\u8bf7\u9009\u62e9\u5173\u8054\u6570\u636e");
        }
        if ((coupon.getCategory().equals(CouponConstants.COUPON_CATEGORY_PRODUCT_CATEGORY) || coupon.getCategory().equals(CouponConstants.COUPON_CATEGORY_BRAND)) && (split = request.getLinkedData().split(",")).length > 1) {
            throw new CrmebException("\u53ea\u80fd\u9009\u62e9\u4e00\u4e2a\u54c1\u7c7b\u6216\u54c1\u724c");
        }
        UpdateWrapper update = Wrappers.update();
        update.set((Object)"name", (Object)request.getName());
        update.set((Object)"is_limited", (Object)(request.getIsLimited() != false ? 1 : 0));
        if (request.getIsLimited().booleanValue() && coupon.getIsLimited().booleanValue()) {
            update.setSql(StrUtil.format((CharSequence)"total = total + {}", (Object[])new Object[]{request.getNum()}));
            update.setSql(StrUtil.format((CharSequence)"last_total = last_total + {}", (Object[])new Object[]{request.getNum()}));
        }
        if (coupon.getIsLimited().booleanValue() && !request.getIsLimited().booleanValue()) {
            update.setSql("last_total = total - last_total");
        }
        update.set((Object)"is_time_receive", (Object)(request.getIsTimeReceive() != false ? 1 : 0));
        if (request.getIsTimeReceive().booleanValue()) {
            update.set((Object)"receive_start_time", (Object)request.getReceiveStartTime());
            update.set((Object)"receive_end_time", (Object)request.getReceiveEndTime());
        }
        update.set((Object)"is_fixed_time", (Object)(request.getIsFixedTime() != false ? 1 : 0));
        if (request.getIsFixedTime().booleanValue()) {
            update.set((Object)"use_start_time", (Object)request.getUseStartTime());
            update.set((Object)"use_end_time", (Object)request.getUseEndTime());
        } else {
            update.set((Object)"day", (Object)request.getDay());
        }
        if (!coupon.getCategory().equals(CouponConstants.COUPON_CATEGORY_UNIVERSAL)) {
            update.set((Object)"linked_data", (Object)request.getLinkedData());
        }
        update.set((Object)"is_repeated", (Object)request.getIsRepeated());
        update.eq((Object)"id", (Object)coupon.getId());
        ArrayList cpList = new ArrayList();
        if (coupon.getCategory().equals(CouponConstants.COUPON_CATEGORY_PRODUCT)) {
            String productIds = request.getLinkedData();
            List productIdList = CrmebUtil.stringToArray((String)productIds);
            productIdList.forEach(pid -> {
                CouponProduct couponProduct = new CouponProduct();
                couponProduct.setPid(pid);
                couponProduct.setCid(coupon.getId());
                cpList.add(couponProduct);
            });
        }
        return (Boolean)this.transactionTemplate.execute(e -> {
            this.update((Wrapper)update);
            if (CollUtil.isNotEmpty((Collection)cpList)) {
                this.couponProductService.deleteByCid(coupon.getId());
                this.couponProductService.saveBatch(cpList, 100);
            }
            return Boolean.TRUE;
        });
    }

    @Override
    public List<Coupon> findProductDetailLimit(Integer proId, Integer merId, Integer limit) {
        String now = DateUtil.now();
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(Coupon::getCategory, (Object)CouponConstants.COUPON_CATEGORY_PRODUCT);
        lqw.eq(Coupon::getReceiveType, (Object)CouponConstants.COUPON_RECEIVE_TYPE_MANUAL);
        lqw.eq(Coupon::getStatus, (Object)1);
        lqw.and(i -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)i.eq(Coupon::getIsTimeReceive, (Object)0)).or(o -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)o.le(Coupon::getReceiveStartTime, (Object)now)).ge(Coupon::getReceiveEndTime, (Object)now);
            });
        });
        lqw.and(i -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)i.eq(Coupon::getIsFixedTime, (Object)0)).or(o -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)o.ge(Coupon::getUseEndTime, (Object)now);
            });
        });
        lqw.apply(" find_in_set({0}, linked_data) ", new Object[]{proId});
        lqw.eq(Coupon::getIsDel, (Object)false);
        lqw.orderByDesc((Object[])new SFunction[]{Coupon::getMoney, Coupon::getId});
        lqw.last(" limit " + limit);
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public List<Coupon> findByMerIdAndMoney(Integer merId, Integer proId, BigDecimal minPrice) {
        String now = DateUtil.now();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("merId", merId);
        map.put("proId", proId);
        map.put("date", now);
        map.put("minPrice", minPrice);
        return this.dao.findByMerIdAndMoney(map);
    }

    @Override
    public List<Coupon> findPlatByMerIdAndMoney(Integer proId, List<Integer> proCategoryIdList, Integer merId, Integer brandId, BigDecimal price) {
        String now = DateUtil.now();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("proId", proId);
        map.put("proCategoryIdList", proCategoryIdList);
        map.put("merId", merId);
        map.put("brandId", brandId);
        map.put("date", now);
        map.put("minPrice", price);
        return this.dao.findPlatByMerIdAndMoney(map);
    }

    @Override
    public List<Coupon> findByIds(List<Integer> couponIdList) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.in(Coupon::getId, couponIdList);
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public List<Coupon> findManyByMerIdAndMoney(Integer merId, List<Integer> proIdList, BigDecimal minPrice) {
        String now = DateUtil.now();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("merId", merId);
        map.put("proIdList", proIdList);
        map.put("nowDate", now);
        map.put("minPrice", minPrice);
        return this.dao.findManyByMerIdAndMoney(map);
    }

    @Override
    public List<Coupon> findManyPlatByMerIdAndMoney(List<Integer> proIdList, List<Integer> proCategoryIdList, List<Integer> merIdList, List<Integer> brandIdList, BigDecimal price) {
        String now = DateUtil.now();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("proIdList", proIdList);
        map.put("proCategoryIdList", proCategoryIdList);
        map.put("merIdList", merIdList);
        map.put("brandIdList", brandIdList);
        map.put("nowDate", now);
        map.put("minPrice", price);
        return this.dao.findManyPlatByMerIdAndMoney(map);
    }

    @Override
    public List<Coupon> sendNewPeopleGift(Integer userId) {
        String newPeopleSwitch = this.systemConfigService.getValueByKey("new_people_present_switch");
        if (StrUtil.isBlank((CharSequence)newPeopleSwitch) || newPeopleSwitch.equals("0")) {
            return null;
        }
        String newPeopleSwitchCouponStr = this.systemConfigService.getValueByKey("new_people_present_coupon");
        if (StrUtil.isBlank((CharSequence)newPeopleSwitchCouponStr)) {
            return null;
        }
        List couponIdList = CrmebUtil.stringToArray((String)newPeopleSwitchCouponStr);
        if (CollUtil.isEmpty((Collection)couponIdList)) {
            return null;
        }
        List<Coupon> couponList = this.findByIds(couponIdList);
        DateTime nowDate = DateUtil.date();
        List<Coupon> canSendCouponList = couponList.stream().filter(coupon -> {
            if (coupon.getIsDel().booleanValue()) {
                return false;
            }
            if (!coupon.getStatus().booleanValue()) {
                return false;
            }
            if (!coupon.getReceiveType().equals(CouponConstants.COUPON_RECEIVE_TYPE_PLAT_SEND)) {
                return false;
            }
            if (coupon.getIsLimited().booleanValue() && coupon.getLastTotal() <= 0) {
                return false;
            }
            if (coupon.getIsTimeReceive().booleanValue()) {
                if (nowDate.compareTo(coupon.getReceiveStartTime()) < 0) {
                    return false;
                }
                if (nowDate.compareTo(coupon.getReceiveEndTime()) > 0) {
                    return false;
                }
            }
            return coupon.getIsFixedTime() == false || nowDate.compareTo(coupon.getUseEndTime()) <= 0;
        }).collect(Collectors.toList());
        if (CollUtil.isEmpty(canSendCouponList)) {
            return null;
        }
        List couponUserList = canSendCouponList.stream().map(coupon -> {
            CouponUser couponUser = new CouponUser();
            couponUser.setCouponId(coupon.getId());
            couponUser.setUid(userId);
            couponUser.setMerId(coupon.getMerId());
            couponUser.setName(coupon.getName());
            couponUser.setPublisher(coupon.getPublisher());
            couponUser.setCategory(coupon.getCategory());
            couponUser.setReceiveType(coupon.getReceiveType());
            couponUser.setCouponType(coupon.getCouponType());
            couponUser.setMoney(coupon.getMoney());
            couponUser.setDiscount(coupon.getDiscount());
            couponUser.setMinPrice(coupon.getMinPrice());
            couponUser.setStatus(CouponConstants.STORE_COUPON_USER_STATUS_USABLE);
            if (!coupon.getIsFixedTime().booleanValue()) {
                String endTime = CrmebDateUtil.addDay((String)CrmebDateUtil.nowDate((String)"yyyy-MM-dd HH:mm:ss"), (int)coupon.getDay(), (String)"yyyy-MM-dd HH:mm:ss");
                couponUser.setStartTime(CrmebDateUtil.nowDateTimeReturnDate((String)"yyyy-MM-dd HH:mm:ss"));
                couponUser.setEndTime(CrmebDateUtil.strToDate((String)endTime, (String)"yyyy-MM-dd HH:mm:ss"));
            } else {
                couponUser.setStartTime(coupon.getUseStartTime());
                couponUser.setEndTime(coupon.getUseEndTime());
            }
            return couponUser;
        }).collect(Collectors.toList());
        Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
            Coupon coupon;
            Boolean deduction = Boolean.TRUE;
            Iterator iterator = canSendCouponList.iterator();
            while (iterator.hasNext() && (deduction = this.deduction((coupon = (Coupon)iterator.next()).getId(), 1, coupon.getIsLimited())).booleanValue()) {
            }
            if (!deduction.booleanValue()) {
                e.setRollbackOnly();
                return Boolean.FALSE;
            }
            deduction = this.couponUserService.saveBatch(couponUserList, 100);
            if (!deduction.booleanValue()) {
                e.setRollbackOnly();
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        });
        if (!execute.booleanValue()) {
            log.error("\u53d1\u9001\u65b0\u4eba\u793c,\u64cd\u4f5c\u6570\u636e\u5e93\u5931\u8d25\uff0c\u7528\u6237ID = {}, \u65b0\u4eba\u793c\u4f18\u60e0\u5238\u914d\u7f6e = {}", (Object)userId, (Object)newPeopleSwitchCouponStr);
            return null;
        }
        return canSendCouponList;
    }
}

