package com.zbkj.common.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * description: 生成结算单信息 response对象
 * author : linchunpeng
 * date : 2023/8/3
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "BcxSettleBillInfoResponse对象", description = "生成结算单信息 response对象")
public class BcxSettleBillInfoResponse implements Serializable {

    @ApiModelProperty(value = "结算对象数量")
    private Integer settleCount;

    @ApiModelProperty(value = "结算业绩报表数量")
    private Integer settleReportCount;

    @ApiModelProperty(value = "结算订单数量")
    private Integer settleOrderCount;

    @ApiModelProperty(value = "实际支付总金额")
    private BigDecimal payTotalPrice;

    @ApiModelProperty(value = "结算总金额")
    private BigDecimal settleTotalPrice;

    @ApiModelProperty(value = "已结算佣金金额")
    private BigDecimal settledPrice;

    @ApiModelProperty(value = "未结算佣金金额")
    private BigDecimal notSettledPrice;

}