package com.zbkj.common.request.bcx;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.io.Serializable;
import java.util.Date;
import java.math.BigDecimal;

/**
 * 发票源单据请求对象
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "BcxFapiaoSourceRequest对象", description = "发票源单据请求对象")
public class BcxFapiaoSourceRequest implements Serializable {
    private static final long serialVersionUID=1L;

    @ApiModelProperty(value = "单号")
    private String sourceNo;

    @ApiModelProperty(value = "0-商品购买 1-平台服务费2-渠道服务费 3-分销服务费")
    private Integer sourceType;

    @ApiModelProperty(value = "开票方")
    private String writer;

    @ApiModelProperty(value = "商品名称")
    private String productInfo;

    @ApiModelProperty(value = "商品三级分类id")
    private Integer categoryId;

    @ApiModelProperty(value = "开票时间：为空-全部,today,yesterday,lately7,lately30,week,preWeek,month,preMonth,year,preYear")
    private String fapiaoTime;

    @ApiModelProperty(value = "生成时间：为空-全部,today,yesterday,lately7,lately30,week,preWeek,month,preMonth,year,preYear")
    private String sourceTime;

    @ApiModelProperty(value = "状态：为空-全部 0-未开票 1-已开票 2-开票中 3-开票失败")
    private Integer fapiaoStatus;

    @ApiModelProperty(value = "关联申请单")
    private String applyNo;

    @ApiModelProperty(value = "关联申请单")
    private String fapiaoNo;
}
