package com.zbkj.common.request;


import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 商品限购请求对象
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "BcxProductQuotaRequest对象", description = "商品限购请求对象")
public class BcxProductQuotaRequest implements Serializable {
    private static final long serialVersionUID = 12342423423L;

    @ApiModelProperty(value = "限购id")
    private Integer id;

    @ApiModelProperty(value = "限购商品id")
    private Integer productId;

    @ApiModelProperty(value = "启用限购 1-启用 0其他-不启用")
    private Boolean enabled;

    @ApiModelProperty(value = "单次限购数量", required = true)
    @Min(value = 1, message = "限购数量至少为1")
    @NotNull
    private Integer oneQuota;

    @ApiModelProperty(value = "用户总限购数量")
    @Min(value = 1, message = "限购数量至少为1")
    private Integer allQuota;

    @ApiModelProperty(value = "商品名称")
    private String name;
}
