package com.zbkj.common.model.huifu;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * <b> 企业钱包交易数据 </b>
 * @author ZXF
 * @create 2023/07/26 0026 16:48
 * @version
 * @注意事项 </b>
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("eb_huifu_wallet_reconciliation")
@ApiModel(value="HuifuWalletReconciliation对象", description="企业钱包交易数据")
public class HuifuWalletReconciliation implements Serializable {

    @ApiModelProperty(value = "id")
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    @ApiModelProperty(value = "更新时间")
    private Date updateTime;

    @ApiModelProperty(value = "交易流水号")
    private String tradeSerialNo;

    @ApiModelProperty(value = "商户号")
    private String merchantNo;

    @ApiModelProperty(value = "交易日期")
    private String tradeDate;

    @ApiModelProperty(value = "请求流水号")
    private String requestSerialNo;

    @ApiModelProperty(value = "交易金额")
    private BigDecimal tradeAmount;

    @ApiModelProperty(value = "交易状态")
    private String tradeStatus;

    @ApiModelProperty(value = "银行交易类型")
    private String bankTradeType;

    @ApiModelProperty(value = "交易订单创建时间")
    private String tradeStartTime;

    @ApiModelProperty(value = "交易订单完成时间")
    private String tradeEndTime;

    @ApiModelProperty(value = "出账方账号")
    private String expendAccountNo;

    @ApiModelProperty(value = "出账方户名")
    private String expendAccountName;

    @ApiModelProperty(value = "出账方企业ID")
    private String expendUniId;

    @ApiModelProperty(value = "出账方银行编码")
    private String expendBankCode;

    @ApiModelProperty(value = "入账方账号")
    private String incomeAccountNo;

    @ApiModelProperty(value = "入账方企业ID")
    private String incomeUniId;

    @ApiModelProperty(value = "入账方户名")
    private String incomeAccountName;

    @ApiModelProperty(value = "入账方银行编码")
    private String incomedBankCode;

    @ApiModelProperty(value = "入账方证件号")
    private String incomeCerNo;

    @ApiModelProperty(value = "商户保留域")
    private String merchantRetain;

//    @ApiModelProperty(value = "分账信息")
//    private String allotAccountInfo;
//
//    @ApiModelProperty(value = "分润信息")
//    private String allotBenefitInfo;

    @ApiModelProperty(value = "交易备注")
    private String remark;

    @ApiModelProperty(value = "手续费")
    private String serviceCharge;

//    @ApiModelProperty(value = "担保信息")
//    private String guaranteeInfo;

}