/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.common.vo;

import cn.hutool.core.collection.CollUtil;
import com.zbkj.common.response.BcxProductMenuResponse;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class BcxProductMenuTree {
    private List<BcxProductMenuResponse> menuList = new ArrayList<BcxProductMenuResponse>();

    public BcxProductMenuTree(List<BcxProductMenuResponse> menuList) {
        this.menuList = menuList;
    }

    public List<BcxProductMenuResponse> buildTree() {
        ArrayList<BcxProductMenuResponse> treeMenus = new ArrayList<BcxProductMenuResponse>();
        for (BcxProductMenuResponse menuNode : this.getRootNode()) {
            menuNode = this.buildChildTree(menuNode);
            treeMenus.add(menuNode);
        }
        return this.sortList(treeMenus);
    }

    private List<BcxProductMenuResponse> sortList(List<BcxProductMenuResponse> treeMenus) {
        treeMenus = treeMenus.stream().sorted(Comparator.comparing(BcxProductMenuResponse::getSort)).collect(Collectors.toList());
        treeMenus.forEach(e -> {
            if (CollUtil.isNotEmpty(e.getChildList())) {
                e.setChildList(this.sortList(e.getChildList()));
            }
        });
        return treeMenus;
    }

    private BcxProductMenuResponse buildChildTree(BcxProductMenuResponse pNode) {
        ArrayList<BcxProductMenuResponse> childMenus = new ArrayList<BcxProductMenuResponse>();
        for (BcxProductMenuResponse menuNode : this.menuList) {
            if (!menuNode.getPid().equals(pNode.getId())) continue;
            childMenus.add(this.buildChildTree(menuNode));
        }
        pNode.setChildList(childMenus);
        return pNode;
    }

    private List<BcxProductMenuResponse> getRootNode() {
        ArrayList<BcxProductMenuResponse> rootMenuLists = new ArrayList<BcxProductMenuResponse>();
        for (BcxProductMenuResponse menuNode : this.menuList) {
            if (!menuNode.getPid().equals(0)) continue;
            rootMenuLists.add(menuNode);
        }
        return rootMenuLists;
    }
}

