package com.zbkj.service.wangshang.notify.service.impl;

import com.zbkj.common.constants.Constants;
import com.zbkj.common.dto.HuifuWalletAccountDto;
import com.zbkj.common.model.huifu.HuifuWalletAccount;
import com.zbkj.service.config.PaymentChannel;
import com.zbkj.service.dao.HuifuWalletAccountDao;
import com.zbkj.service.service.TransactionLogService;
import com.zbkj.service.wangshang.api.domain.RequestHead;
import com.zbkj.service.wangshang.api.domain.model.notify.MerchantprodMerchantArrangementInfoNotifyModel;
import com.zbkj.service.wangshang.api.internal.parser.xml.XmlConverter;
import com.zbkj.service.wangshang.api.service.notify.MerchantprodMerchantArrangementInfoNotifyRequest;
import com.zbkj.service.wangshang.handle.CommomRequstHandle;
import com.zbkj.service.wangshang.notify.service.MybankNotifyService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;

@Service(value = "merchantprodMerchantArrangementInfoNotifyService")
public class MerchantprodMerchantArrangementInfoNotifyServiceImpl implements MybankNotifyService {


    private static final Logger logger = LoggerFactory.getLogger(MerchantprodMerchantArrangementInfoNotifyServiceImpl.class);
    @Autowired
    private CommomRequstHandle commomRequstHandle;

    @Resource
    private HuifuWalletAccountDao huifuWalletAccountDao;
    @Autowired
    TransactionLogService transactionLogService;

    @Override
    public String notifyHandle(String context, String function) throws Exception {
        logger.info("========= > 授权/解约成功通知接口：ant.mybank.merchantprod.merchant.arrangement.info.notify");
        logger.info("========= > 请求报文："+context);
        //通知内容转换
        MerchantprodMerchantArrangementInfoNotifyRequest arrangeMentInfoNotify =
                XmlConverter.getInstance().toResponse(context, MerchantprodMerchantArrangementInfoNotifyRequest.class);
        RequestHead head = arrangeMentInfoNotify.getMerchantprodMerchantArrangementInfoNotify().getRequestHead();
        boolean flag = false;
        try {
            //通知内容保存
            flag = saveNotify(arrangeMentInfoNotify.getMerchantprodMerchantArrangementInfoNotify().getMerchantprodMerchantArrangementInfoNotifyModel());
        }catch (Exception e){
            logger.error("========= > 授权/解约成功通知接口：ant.mybank.merchantprod.merchant.arrangement.info.notify:"+e.getMessage());
        }
        //响应结果根据执行结果统一处理
        String response = commomRequstHandle.getSignResult(flag, head);
        transactionLogService.save("授权/解约成功通知接口：ant.mybank.merchantprod.merchant.arrangement.info.notify", Constants.Y, context,response, PaymentChannel.WANGSHANG.toString());
        return response;


    }

    private boolean saveNotify(MerchantprodMerchantArrangementInfoNotifyModel model){

        HuifuWalletAccountDto dto = huifuWalletAccountDao.getHuifuWalletAccountByWalletNo(model.getMerchantId());
        if(dto == null){
            return false;
        }
        if(model.getArrangementStatus().equals(dto.getArrangementStatus())){
            return true;
        }
        HuifuWalletAccount hwa = huifuWalletAccountDao.selectById(dto.getId());
        hwa.setArrangementStatus(model.getArrangementStatus());
        hwa.setArrangementNo(model.getArrangementNo());
        if("INVALID_TO_BE_CONFIRM".equals(model.getArrangementStatus())||"UN_VALID".equals(model.getArrangementStatus())){
            hwa.setAcctStat("F");
            hwa.setFailReason("合约未确认或无效");
        }else if("NOT_EXIST".equals(model.getArrangementStatus())){
            hwa.setFailReason("合约不存在");
            hwa.setAcctStat("C");
        }else{
            hwa.setFailReason("");
            hwa.setAcctStat("N");
        }
        hwa.setUpdateTime(new Date());
        huifuWalletAccountDao.updateById(hwa);
        return true;
    }
}
