package com.zbkj.service.wangshang.notify.service.impl;


import com.zbkj.common.constants.Constants;
import com.zbkj.service.config.PaymentChannel;
import com.zbkj.service.service.TransactionLogService;
import com.zbkj.service.wangshang.api.domain.RequestHead;
import com.zbkj.service.wangshang.api.domain.model.notify.BkcloudfundsVostroNotifyModel;
import com.zbkj.service.wangshang.api.internal.parser.xml.XmlConverter;
import com.zbkj.service.wangshang.api.service.notify.BkcloudfundsVostroNotifyRequest;
import com.zbkj.service.wangshang.handle.CommomRequstHandle;
import com.zbkj.service.wangshang.notify.service.MybankNotifyService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 来账通知接口实现
 * ant.mybank.bkcloudfunds.vostro.notify
 **/
@Service(value = "bkcloudfundsVostroNotifyService")
public class BkcloudfundsVostroNotifyServiceImpl implements MybankNotifyService {

    private static final Logger logger = LoggerFactory.getLogger(BkcloudfundsVostroNotifyServiceImpl.class);
    @Autowired
    private CommomRequstHandle commomRequstHandle;
    @Autowired
    TransactionLogService transactionLogService;

    @Override
    public String notifyHandle(String context, String function) throws Exception {
        logger.info("========= > 来账通知接口实现：ant.mybank.bkcloudfunds.vostro.notify");
        logger.info("========= > 请求报文："+context);
        //通知内容转换
        BkcloudfundsVostroNotifyRequest vostroNotifyRequest =
                XmlConverter.getInstance().toResponse(context, BkcloudfundsVostroNotifyRequest.class);
        RequestHead head = vostroNotifyRequest.getBkcloudfundsVostroNotify().getRequestHead();
        //通知内容保存
        boolean flag = saveNotify(vostroNotifyRequest.getBkcloudfundsVostroNotify().getBkcloudfundsVostroNotifyModel());
        //响应结果根据执行结果统一处理
        String response = commomRequstHandle.getSignResult(flag, head);
        transactionLogService.save("来账通知接口实现：ant.mybank.bkcloudfunds.vostro.notify", Constants.Y, context,response, PaymentChannel.WANGSHANG.toString());
        return response;
    }

    private boolean saveNotify(BkcloudfundsVostroNotifyModel model) {
        //TODO

        return true;
    }

}
