package com.zbkj.service.wangshang.api.domain.model.notify;


import com.zbkj.service.wangshang.api.domain.ResponseBody;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

/**
 * 商户入驻结果通知（异步通知接口）< ant.mybank.merchantprod.merch.notify>
 * <p>
 * 开户结果异步通知
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlRootElement(name = "body")
public class MerchantprodMerchNotifyModel extends ResponseBody {

    private static final long serialVersionUID = -3264596667211388155L;
    /**
     * 外部商户号
     */
    @XmlElement(name = "OutMerchantId")
    private String outMerchantId;

    /**
     * 申请单号
     */
    @XmlElement(name = "OrderNo")
    private String orderNo;

    /**
     * 商户号
     * <p>
     * 网商为商户分配的商户号，通过商户入驻结果查询接口获取。
     */
    @XmlElement(name = "MerchantId")
    private String merchantId;

    /**
     * 开户结果
     * 可选值：
     * 1：成功
     * 2：失败
     */
    @XmlElement(name = "RegisterStatus")
    private String registerStatus;

    /**
     * 外部交易号
     */
    @XmlElement(name = "OutTradeNo")
    private String outTradeNo;

    /**
     * 异步通知类型
     */
    @XmlElement(name = "AsyncNotifyType")
    private String asyncNotifyType;

    /**
     * 户失败原因返回。当商户开户结果为失败时返回。可能出现的失败原因描述见附录。
     */
    @XmlElement(name = "FailReason")
    private String failReason;

    public String getOutMerchantId() {
        return outMerchantId;
    }

    public void setOutMerchantId(String outMerchantId) {
        this.outMerchantId = outMerchantId;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getMerchantId() {
        return merchantId;
    }

    public void setMerchantId(String merchantId) {
        this.merchantId = merchantId;
    }

    public String getRegisterStatus() {
        return registerStatus;
    }

    public void setRegisterStatus(String registerStatus) {
        this.registerStatus = registerStatus;
    }

    public String getOutTradeNo() {
        return outTradeNo;
    }

    public void setOutTradeNo(String outTradeNo) {
        this.outTradeNo = outTradeNo;
    }

    public String getFailReason() {
        return failReason;
    }

    public void setFailReason(String failReason) {
        this.failReason = failReason;
    }

    public String getAsyncNotifyType() {
        return asyncNotifyType;
    }

    public void setAsyncNotifyType(String asyncNotifyType) {
        this.asyncNotifyType = asyncNotifyType;
    }
}