package com.zbkj.service.wangshang.api.domain.model.notify;

import com.zbkj.service.wangshang.api.domain.ResponseBody;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

/**
 * 协议授权代扣通知结果<ant.mybank.bkcloudfunds.protocol.withhold.result.notify>
 * <p>
 * 平台可以通过该接口获取协议授权代扣任务执行的结果（是否成功）通知；
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlRootElement(name = "body")
public class BkcloudfundsProtocolWithholdResultNotifyModel extends ResponseBody {

    /**
     * 合作方机构号（网商银行分配）
     */
    @XmlElement(name = "IsvOrgId")
    private String isvOrgId;

    /**
     * 订单类型
     */
    @XmlElement(name = "OrderType")
    private String orderType;

    /**
     * 网商订单号
     */
    @XmlElement(name = "OrderNo")
    private String orderNo;

    /**
     * 外部流水号
     */
    @XmlElement(name = "OutTradeNo")
    private String outTradeNo;

    /**
     * 当前网商操作单号
     */
    @XmlElement(name = "OperateNo")
    private String operateNo;

    /**
     * 交易金额(金额为分)
     */
    @XmlElement(name = "TotalAmount")
    private String totalAmount;

    /**
     * 冻结部分出金（分）
     */
    @XmlElement(name = "FreezeAmount")
    private String freezeAmount;

    /**
     * 可用部分金额（分）
     */
    @XmlElement(name = "AvailableAmount")
    private String availableAmount;

    /**
     * 币种，默认CNY
     */
    @XmlElement(name = "Currency")
    private String currency;

    /**
     * 状态(SUCCESS, FAIL)
     */
    @XmlElement(name = "Status")
    private String status;

    /**
     * 交易完结时间  yyyyMMddHHmmss
     */
    @XmlElement(name = "FinishDate")
    private String finishDate;

    /**
     * 错误码
     * FAIL时出现
     */
    @XmlElement(name = "ErrorCode")
    private String errorCode;

    /**
     * 错误描述
     */
    @XmlElement(name = "ErrorDesc")
    private String errorDesc;

    /**
     * 扩展字段  要带上OutUserId
     */
    @XmlElement(name = "ExtInfo")
    private String extInfo;

    public String getIsvOrgId() {
        return isvOrgId;
    }

    public void setIsvOrgId(String isvOrgId) {
        this.isvOrgId = isvOrgId;
    }

    public String getOrderType() {
        return orderType;
    }

    public void setOrderType(String orderType) {
        this.orderType = orderType;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getOutTradeNo() {
        return outTradeNo;
    }

    public void setOutTradeNo(String outTradeNo) {
        this.outTradeNo = outTradeNo;
    }

    public String getOperateNo() {
        return operateNo;
    }

    public void setOperateNo(String operateNo) {
        this.operateNo = operateNo;
    }

    public String getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(String totalAmount) {
        this.totalAmount = totalAmount;
    }

    public String getFreezeAmount() {
        return freezeAmount;
    }

    public void setFreezeAmount(String freezeAmount) {
        this.freezeAmount = freezeAmount;
    }

    public String getAvailableAmount() {
        return availableAmount;
    }

    public void setAvailableAmount(String availableAmount) {
        this.availableAmount = availableAmount;
    }

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getFinishDate() {
        return finishDate;
    }

    public void setFinishDate(String finishDate) {
        this.finishDate = finishDate;
    }

    public String getErrorCode() {
        return errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorDesc() {
        return errorDesc;
    }

    public void setErrorDesc(String errorDesc) {
        this.errorDesc = errorDesc;
    }

    public String getExtInfo() {
        return extInfo;
    }

    public void setExtInfo(String extInfo) {
        this.extInfo = extInfo;
    }
}