package com.zbkj.service.wangshang.api.domain.model.notify;


import com.zbkj.service.wangshang.api.domain.ResponseBody;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

/**
 * 商户余额解冻结果通知接口
 * <ant.mybank.bkcloudfunds.merchant.account.unfreeze.notify>
 * <p>
 * TODO
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlRootElement(name = "body")
public class BkcloudfundsMerchantAccountUnfreezeNotifyModel extends ResponseBody {


    private static final long serialVersionUID = 700659358323919417L;

    /**
     * 合作方机构号（网商银行分配）
     */
    @XmlElement(name = "IsvOrgId")
    private String isvOrgId;

    /**
     * 请求唯一单号
     */
    @XmlElement(name = "OutTradeNo")
    private String outTradeNo;

    /**
     * 网商操作号
     */
    @XmlElement(name = "OperateNo")
    private String operateNo;

    /**
     * 商户号
     */
    @XmlElement(name = "MerchantId")
    private String merchantId;

    /**
     * 账户类型
     */
    @XmlElement(name = "AccountType")
    private String accountType;

    /**
     * 币种CNY
     */
    @XmlElement(name = "Currency")
    private String currency;

    /**
     * 状态，
     * SUCCESS：成功
     * FAIL：失败
     */
    @XmlElement(name = "Status")
    private String status;

    /**
     * 完成时间
     * yyyyMMddHHmmss
     */
    @XmlElement(name = "FinishTime")
    private String finishTime;

    /**
     * 错误码 FAIL时出现
     */
    @XmlElement(name = "ErrorCode")
    private String errorCode;

    /**
     * 错误描述 FAIL时出现
     */
    @XmlElement(name = "ErrorDesc")
    private String errorDesc;

    public String getIsvOrgId() {
        return isvOrgId;
    }

    public void setIsvOrgId(String isvOrgId) {
        this.isvOrgId = isvOrgId;
    }

    public String getOutTradeNo() {
        return outTradeNo;
    }

    public void setOutTradeNo(String outTradeNo) {
        this.outTradeNo = outTradeNo;
    }

    public String getOperateNo() {
        return operateNo;
    }

    public void setOperateNo(String operateNo) {
        this.operateNo = operateNo;
    }

    public String getMerchantId() {
        return merchantId;
    }

    public void setMerchantId(String merchantId) {
        this.merchantId = merchantId;
    }

    public String getAccountType() {
        return accountType;
    }

    public void setAccountType(String accountType) {
        this.accountType = accountType;
    }

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getFinishTime() {
        return finishTime;
    }

    public void setFinishTime(String finishTime) {
        this.finishTime = finishTime;
    }

    public String getErrorCode() {
        return errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorDesc() {
        return errorDesc;
    }

    public void setErrorDesc(String errorDesc) {
        this.errorDesc = errorDesc;
    }
}
