package com.zbkj.service.wangshang.api.domain.model;

import com.zbkj.service.wangshang.api.MybankObject;
import com.zbkj.service.wangshang.api.domain.RespInfo;

import javax.xml.bind.annotation.*;

/**
 * 协议代扣退款申请接口<ant.mybank.bkcloudfunds.protocol.withhold.refund.apply>
 * 响应模型
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlRootElement(name = "body")
public class ProtocolWithholdRefundApplyResponseModel extends MybankObject {

    private static final long serialVersionUID = -8509788023116497080L;

    /**
     * 返回码组件
     */
    @XmlElementRef
    private RespInfo respInfo;

    /**
     * 合作方机构号
     */
    @XmlElement(name = "IsvOrgId")
    private String isvOrgId;

    /**
     * 退款参与方类型 商户(MERCHANT)、 平台(PLATFORM)
     */
    @XmlElement(name = "ParticipantType")
    private String participantType;

    /**
     * ParticipantId	退款参与方id
     * 如果是商户，则填入merchantId,
     * 如果是平台，则填入isvOrgId
     */
    @XmlElement(name = "ParticipantId")
    private String participantId;

    /**
     * 关联网商订单号
     */
    @XmlElement(name = "RelateOrderNo")
    private String relateOrderNo;

    /**
     * 退款网商订单号
     */
    @XmlElement(name = "RefundOrderNo")
    private String refundOrderNo;

    /**
     * 退款交易号
     */
    @XmlElement(name = "OutRefundNo")
    private String outRefundNo;

    public RespInfo getRespInfo() {return respInfo;}
    public void setRespInfo(RespInfo respInfo) {this.respInfo = respInfo;}

    public String getIsvOrgId() {return isvOrgId;}
    public void setIsvOrgId(String isvOrgId) {this.isvOrgId = isvOrgId;}

    public String getParticipantType() {return participantType;}
    public void setParticipantType(String participantType) {this.participantType = participantType;}

    public String getParticipantId() {return participantId;}
    public void setParticipantId(String participantId) {this.participantId = participantId;}

    public String getRelateOrderNo() {return relateOrderNo;}
    public void setRelateOrderNo(String relateOrderNo) {this.relateOrderNo = relateOrderNo;}

    public String getRefundOrderNo() {return refundOrderNo;}
    public void setRefundOrderNo(String refundOrderNo) {this.refundOrderNo = refundOrderNo;}

    public String getOutRefundNo() {return outRefundNo;}
    public void setOutRefundNo(String outRefundNo) {this.outRefundNo = outRefundNo;}
}
