package com.zbkj.service.wangshang.api.domain.model;


import com.zbkj.service.wangshang.api.domain.RequestBody;
import com.zbkj.service.wangshang.api.internal.util.CDataAdapter;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

/**
 * 商户修改结果查询<ant.mybank.merchantprod.merch.async.updateMerchant.query>
 * <p>
 * 该接口可查询商户修改结果。当合作方请求商户开户后，系统会异步通知修改结果。合作方也可通过该接口回查商户修改结果。
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlRootElement(name = "body")
public class MerchantprodMerchAsyncUpdateMerchantQueryRequestModel extends RequestBody {

    private static final long serialVersionUID = 5369511498215530587L;
    /**
     * 合作方机构号
     * <p>
     * 网商银行分配
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "IsvOrgId")
    private String isvOrgId;

    /**
     * 申请单号
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "OrderNo")
    private String orderNo;

    public String getIsvOrgId() {
        return isvOrgId;
    }

    public void setIsvOrgId(String isvOrgId) {
        this.isvOrgId = isvOrgId;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }
}