package com.zbkj.service.wangshang.api.domain.model;

import com.zbkj.service.wangshang.api.domain.RequestBody;
import com.zbkj.service.wangshang.api.domain.RespInfo;

import javax.xml.bind.annotation.*;


/**
 * 通用下载申请结果查询（异步场景）
 * <ant.mybank.bkmbp.stmt.apply.result.common.query>
 * **/
@XmlAccessorType(XmlAccessType.FIELD)
@XmlRootElement(name ="body")
public class BkmbpStmtApplyResultCommonQueryResponseModel extends RequestBody {


    private static final long serialVersionUID = 1100343568595582622L;

    /**
     * 返回码组件
     */
    @XmlElementRef
    private RespInfo respInfo;

    /**
     * 合作方机构号
     * <p>
     * 网商银行分配
     * */
    @XmlElement(name = "IsvOrgId")
    private String isvOrgId;

    /**
     * 外部交易号
     */
    @XmlElement(name = "OutRequestNo")
    private String outRequestNo;

    /**
     * 下载账单类型
     * 品牌商收费账单明细文件（PLAT_FEE_STMT_BILL），品牌商收费日账单文件（PLAT_FEE_DAY_SUMMARY_STMT_BILL），品牌商收费月账单文件（PLAT_FEE_MON_SUMMARY_STMT_BILL）
     */
    @XmlElement(name = "StmtType")
    private String stmtType;

    /**
     * 回单号(申请成功时网商针对一笔请求生成的单号)
     */
    @XmlElement(name = "BackOrderNo")
    private String backOrderNo;

    /**
     * 申请状态
     */
    @XmlElement(name = "Status")
    private String status;

    /**
     * 错误码
     */
    @XmlElement(name = "ErrorCode")
    private String errorCode;

    /**
     * 电子回单CDN下载链接
     */
    @XmlElement(name = "PdfDownloadUrl")
    private String pdfDownloadUrl;


    public RespInfo getRespInfo() {
        return respInfo;
    }

    public void setRespInfo(RespInfo respInfo) {
        this.respInfo = respInfo;
    }

    public String getIsvOrgId() {
        return isvOrgId;
    }

    public void setIsvOrgId(String isvOrgId) {
        this.isvOrgId = isvOrgId;
    }

    public String getOutRequestNo() {
        return outRequestNo;
    }

    public void setOutRequestNo(String outRequestNo) {
        this.outRequestNo = outRequestNo;
    }

    public String getStmtType() {
        return stmtType;
    }

    public void setStmtType(String stmtType) {
        this.stmtType = stmtType;
    }

    public String getBackOrderNo() {
        return backOrderNo;
    }

    public void setBackOrderNo(String backOrderNo) {
        this.backOrderNo = backOrderNo;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getErrorCode() {
        return errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getPdfDownloadUrl() {
        return pdfDownloadUrl;
    }

    public void setPdfDownloadUrl(String pdfDownloadUrl) {
        this.pdfDownloadUrl = pdfDownloadUrl;
    }
}
