package com.zbkj.service.wangshang.api.domain.model;


import com.zbkj.service.wangshang.api.domain.RequestBody;
import com.zbkj.service.wangshang.api.internal.util.CDataAdapter;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

/**
 * 获取对账文件下载链接接口 <ant.mybank.bkcloudfunds.recon.query>
 * 请求模型
 * <p>
 * TODO
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlRootElement(name = "body")
public class BkcloudfundsReconQueryRequestModel extends RequestBody {

    private static final long serialVersionUID = 4295021262282231168L;

    /**
     * 合作方机构号
     * <p>
     * 网商银行分配
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "IsvOrgId")
    private String isvOrgId;

    /**
     * 账单日期
     * <p>
     * 格式为yyyyMMdd(20201101<=Date<=Today)
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "Date")
    private String date;

    /**
     * 外部交易号
     * <p>
     * 由合作方系统生成，只能包含字母、数字、下划线；需保证合作方系统不重复。
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "OutTradeNo")
    private String outTradeNo;

    /**
     * 下载账单类型
     *
     * 01-云资金对账单
     * 02-云资金对账明细
     * 03-云资金账户变动
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "Type")
    private String type;

    /**
     * 扩展信息，Map的json序列化后Base64
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "ExtInfo")
    private String extInfo;

    public String getIsvOrgId() {
        return isvOrgId;
    }

    public void setIsvOrgId(String isvOrgId) {
        this.isvOrgId = isvOrgId;
    }

    public String getDate() {
        return date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public String getOutTradeNo() {
        return outTradeNo;
    }

    public void setOutTradeNo(String outTradeNo) {
        this.outTradeNo = outTradeNo;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getExtInfo() {
        return extInfo;
    }

    public void setExtInfo(String extInfo) {
        this.extInfo = extInfo;
    }
}