package com.zbkj.service.wangshang.api.domain.model;

import com.zbkj.service.wangshang.api.MybankObject;
import com.zbkj.service.wangshang.api.domain.RespInfo;

import javax.xml.bind.annotation.*;

/**
 * 协议授权代扣查询结果<ant.mybank.bkcloudfunds.protocol.withhold.query>
 * 响应模型
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlRootElement(name = "body")
public class BkcloudfundsProtocolWithholdQueryResponseModel extends MybankObject {

    private static final long serialVersionUID = -962447055602128741L;
    /**
     * 返回码组件
     */
    @XmlElementRef
    private RespInfo respInfo;

    /**
     * 合作方机构号
     */
    @XmlElement(name = "IsvOrgId")
    private String isvOrgId;

    /**
     * 当前操作交易号
     */
    @XmlElement(name = "OperateNo")
    private String operateNo;

    /**
     * 外部订单请求流水号
     */
    @XmlElement(name = "OutTradeNo")
    private String outTradeNo;

    /**
     * 交易金额(金额为分)
     */
    @XmlElement(name = "TotalAmount")
    private String totalAmount;

    /**
     * 冻结部分出金（分）
     */
    @XmlElement(name = "FreezeAmount")
    private String freezeAmount;

    /**
     * 可用部分金额（分）
     */
    @XmlElement(name = "AvailableAmount")
    private String availableAmount;

    /**
     * 币种，默认CNY
     */
    @XmlElement(name = "Currency")
    private String currency;

    /**
     * 记账时间
     */
    @XmlElement(name = "FinishDate")
    private String finishDate;

    /**
     * 状态(SUCCESS, DEALING，FAIL)
     */
    @XmlElement(name = "Status")
    private String status;

    /**
     * 错误码
     */
    @XmlElement(name = "ErrorCode")
    private String errorCode;

    /**
     * 错误描述
     */
    @XmlElement(name = "ErrorDesc")
    private String errorDesc;

    /**
     * 扩展信息
     */
    @XmlElement(name = "ExtInfo")
    private String extInfo;


    public RespInfo getRespInfo() {
        return respInfo;
    }

    public void setRespInfo(RespInfo respInfo) {
        this.respInfo = respInfo;
    }

    public String getIsvOrgId() {
        return isvOrgId;
    }

    public void setIsvOrgId(String isvOrgId) {
        this.isvOrgId = isvOrgId;
    }

    public String getOperateNo() {
        return operateNo;
    }

    public void setOperateNo(String operateNo) {
        this.operateNo = operateNo;
    }

    public String getOutTradeNo() {
        return outTradeNo;
    }

    public void setOutTradeNo(String outTradeNo) {
        this.outTradeNo = outTradeNo;
    }

    public String getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(String totalAmount) {
        this.totalAmount = totalAmount;
    }

    public String getFreezeAmount() {
        return freezeAmount;
    }

    public void setFreezeAmount(String freezeAmount) {
        this.freezeAmount = freezeAmount;
    }

    public String getAvailableAmount() {
        return availableAmount;
    }

    public void setAvailableAmount(String availableAmount) {
        this.availableAmount = availableAmount;
    }

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getFinishDate() {
        return finishDate;
    }

    public void setFinishDate(String finishDate) {
        this.finishDate = finishDate;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getErrorCode() {
        return errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorDesc() {
        return errorDesc;
    }

    public void setErrorDesc(String errorDesc) {
        this.errorDesc = errorDesc;
    }

    public String getExtInfo() {
        return extInfo;
    }

    public void setExtInfo(String extInfo) {
        this.extInfo = extInfo;
    }

}