package com.zbkj.service.wangshang.api.config;


public enum WSTransactionType {
    /**
     * 订单分账
     */
    ORDER_SHARE("订单分账"),

    /**
     * 分账退回
     */
    SHARE_REFUND("分账退回"),

    /**
     * 余额支付
     */
    BALANCE_PAY("余额支付"),

    /**
     * 提现
     */
    WITHDRAW("提现"),

    /**
     * 大额汇入
     */
    VOSTRO_TRANSFER("大额汇入"),

    /**
     * 子户来账
     */
    VOSTRO_SUB_ACCOUNT("子户来账"),

    /**
     * 退汇
     */
    REEXCHANGE("退汇"),

    /**
     * 非订单补贴
     */
    SUBSIDY("非订单补贴"),

    /**
     * 商户结算
     */
    MERCHANT_STMT("商户结算"),

    /**
     * 商户账单交易支付
     */
    MERCHANT_TRADE_DETAIL_PAY("商户账单交易支付"),

    /**
     * 网商结算户单笔代付至子户
     */
    SETTLE_PAYMENT("网商结算户单笔代付至子户"),

    /**
     * 收银台支付
     */
    CASHIER_PAY("收银台支付"),

    /**
     * 云资金小程序-充值
     */
    DEPOSIT("云资金小程序-充值"),

    /**
     * 来账退款
     */
    VOSTRO_REFUND("来账退款"),

    /**
     * 余额支付退款
     */
    BALANCE_PAY_REFUND("余额支付退款"),

    /**
     * 商户资金解冻
     */
    MERCHANT_FUNDS_UNFREEZE("商户资金解冻"),

    /**
     * 商户结算并冻结
     */
    MERCHANT_STMT_AVAILABLE_FREEZE("商户结算并冻结"),

    /**
     * 统一支付退款
     */
    UNIFIED_PAY_REFUND("统一支付退款"),

    /**
     * 统一代扣
     */
    UNIFIED_WITHHOLD("统一代扣"),

    /**
     * 网联子户来账
     */
    VOSTRO_SUB_ACCOUNT_NETS_UNION("网联子户来账"),

    /**
     * 平台营销子户代扣
     */
    PLATFORM_MARKETING_WITHHOLD("平台营销子户代扣");

    private final String description;

    WSTransactionType(String description) {
        this.description = description;
    }

    /**
     * 获取交易描述
     * @return 交易描述
     */
    public String getDescription() {
        return description;
    }

    /**
     * 根据交易类型查询交易描述
     * @param type 交易类型
     * @return 交易描述
     */
    public static String getDescriptionByType(String type) {
        for (WSTransactionType transactionType : WSTransactionType.values()) {
            if (transactionType.name().equals(type)) {
                return transactionType.getDescription();
            }
        }
        return null;
    }

}