package com.zbkj.service.wangshang.api.config;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class MybankConfig {
    /**
     * 应用ID
     * <p>
     * 由浙江网商银行统一分配,用于识别合作伙伴应用系统，即对端系统编号。
     * 联调前线下提供。
     */
    public static String appId;

    /**
     * 合作方机构号（网商银行分配）
     */
    public static String isvOrgId;

    /**
     * ISV请求报文签名私钥
     * 密钥格式：PKCS8
     * 密钥长度：2048
     * 公私钥生成可参考支付宝开放平台JAVA签名工具使用
     */
    public static String privateKey;

    /**
     * 网商银行网关公钥
     * <p>
     * 用于验签网商银行网关主动发送的通知报文
     */
    public static String mybankPublicKey;
    /**
     * 网商测试公钥（isv 验签网商报文使用）
     * <p>
     * 用于验签网商银行网关返回的报文
     */
    public static String checkPublicKey;

    /**
     * 交互报文格式
     * 可用值：XML
     */
    public static String format;

    /**
     * 交互报文字符编码
     * 可用值：UTF-8
     */
    public static String charset;

    /**
     * 交互报文签名方式
     * 可用值：RSA
     */
    public static String signType;

    /**
     * 以下API接口专用请求网关地址
     * ant.mybank.merchantprod.merchant.register
     * ant.mybank.merchantprod.merchant.register.query
     * ant.mybank.merchantprod.merchant.updateMerchant
     * ant.mybank.merchantprod.merchant.query
     * ant.mybank.merchantprod.merchant.addMerchantConfig
     * ant.mybank.merchantprod.merchant.queryOpenId
     * ant.mybank.bkmerchanttrade.pay
     * ant.mybank.bkmerchanttrade.prePay
     * ant.mybank.bkmerchanttrade.dynamicOrder
     * ant.mybank.bkmerchanttrade.payQuery
     * ant.mybank.bkmerchanttrade.payClose
     * ant.mybank.bkmerchanttrade.payCancel
     */
    public static String spServerUrl;

    /**
     * 仅限 图片上传功能 & 对公账户打款验证服务 & 以下API接口 之外的所有API接口请求使用
     * ant.mybank.merchantprod.merchant.register
     * ant.mybank.merchantprod.merchant.register.query
     * ant.mybank.merchantprod.merchant.updateMerchant
     * ant.mybank.merchantprod.merchant.query
     * ant.mybank.merchantprod.merchant.addMerchantConfig
     * ant.mybank.merchantprod.merchant.queryOpenId
     * ant.mybank.bkmerchanttrade.pay
     * ant.mybank.bkmerchanttrade.prePay
     * ant.mybank.bkmerchanttrade.dynamicOrder
     * ant.mybank.bkmerchanttrade.payQuery
     * ant.mybank.bkmerchanttrade.payClose
     * ant.mybank.bkmerchanttrade.payCancel
     * 请求网关地址
     */
    public static String serverUrl;

    /**
     * 图片上传功能网关请求地址
     */
    public static String uploadphotoUrl;

    /**
     * 文件上传功能网关请求地址
     */
    public static String uploadFileUrl;

    /**
     * 对公账户打款验证服务 - 打款申请网关请求地址
     * 测试环境需要对请求IP地址进行加白
     */
    public static String kybApplyUrl;

    /**
     * 对公账户打款验证服务 - 打款验证网关请求地址
     * 测试环境需要对请求IP地址进行加白
     */
    public static String kybMatchUrl;

    /**
     * 极简网络公共请求地址
     */
    public static String bkServerUrl;

    /**
     * 专用资金款项管理接口请求地址
     */
    public static String bkOpenApiUrl;

    /**
     * sftp服务器地址
     */
    public static String sftpAddress;

    /**
     * sftp服务器用户名
     */
    public static String sftpUsername;

    /**
     * sftp服务器密钥
     */
    public static String sftpPassword;

    /**
     * sftp服务器端口
     */
    public static int sftpPort;

    /**
     * sftp重试间隔时间
     */
    public static int sftpUploadSleep;

    /**
     * sftp重试次数
     */
    public static int sftpUploadRetry;

    /**
     * 接口版本号
     */
    public static String functionVersion;


    @Value("${mybank.api.appId}")
    public void setAppId(String appId) {
        MybankConfig.appId = appId;
    }

    @Value("${mybank.api.isvOrgId}")
    public void setIsvOrgId(String isvOrgId) {
        MybankConfig.isvOrgId = isvOrgId;
    }

    @Value("${mybank.api.privateKey}")
    public void setPrivateKey(String privateKey) {
        MybankConfig.privateKey = privateKey;
    }

    @Value("${mybank.api.mybankPublicKey}")
    public void setMybankPublicKey(String mybankPublicKey) {
        MybankConfig.mybankPublicKey = mybankPublicKey;
    }
    @Value("${mybank.api.checkPublicKey}")
    public void setCheckPublicKey(String checkPublicKey) {
        MybankConfig.checkPublicKey = checkPublicKey;
    }

    @Value("${mybank.api.format}")
    public void setFormat(String format) {
        MybankConfig.format = format;
    }

    @Value("${mybank.api.charset}")
    public void setCharset(String charset) {
        MybankConfig.charset = charset;
    }

    @Value("${mybank.api.signType}")
    public void setSignType(String signType) {
        MybankConfig.signType = signType;
    }

    @Value("${mybank.api.serverUrl}")
    public void setServerUrl(String serverUrl) {
        MybankConfig.serverUrl = serverUrl;
    }

    @Value("${mybank.api.uploadphotoUrl}")
    public void setUploadphotoUrl(String uploadphotoUrl) {
        MybankConfig.uploadphotoUrl = uploadphotoUrl;
    }

    @Value("${mybank.api.uploadFileUrl}")
    public void setUploadFileUrl(String uploadFileUrl) { MybankConfig.uploadFileUrl = uploadFileUrl; }

    @Value("${mybank.api.kybApplyUrl}")
    public void setKybApplyUrl(String kybApplyUrl) {
        MybankConfig.kybApplyUrl = kybApplyUrl;
    }

    @Value("${mybank.api.kybMatchUrl}")
    public void setKybMatchUrl(String kybMatchUrl) {
        MybankConfig.kybMatchUrl = kybMatchUrl;
    }

    @Value("${mybank.api.spServerUrl}")
    public void setSpServerUrl(String spServerUrl) {
        MybankConfig.spServerUrl = spServerUrl;
    }

    @Value("${mybank.api.bkServerUrl}")
    public void setBkServerUrl(String bkServerUrl) {
        MybankConfig.bkServerUrl = bkServerUrl;
    }

    @Value("${mybank.api.bkOpenApiUrl}")
    public void setBkOpenApiUrl(String bkOpenApiUrl) {
        MybankConfig.bkOpenApiUrl = bkOpenApiUrl;
    }

    @Value("${mybank.api.sftp.address}")
    public void setSftpAddress(String sftpAddress) {
        MybankConfig.sftpAddress = sftpAddress;
    }

    @Value("${mybank.api.sftp.username}")
    public void setSftpUsername(String sftpUsername) {
        MybankConfig.sftpUsername = sftpUsername;
    }

    @Value("${mybank.api.sftp.password}")
    public void setSftpPassword(String sftpPassword) {
        MybankConfig.sftpPassword = sftpPassword;
    }

    @Value("${mybank.api.sftp.port}")
    public void setSftpPort(int sftpPort) {
        MybankConfig.sftpPort = sftpPort;
    }

    @Value("${mybank.api.sftp.uploadSleep}")
    public void setSftpUploadSleep(int sftpUploadSleep) {
        MybankConfig.sftpUploadSleep = sftpUploadSleep;
    }

    @Value("${mybank.api.sftp.uploadRetry}")
    public void setSftpUploadRettry(int sftpUploadRetry) {
        MybankConfig.sftpUploadRetry = sftpUploadRetry;
    }

    @Value("${mybank.api.function.version}")
    public  void setFunctionVersion(String functionVersion) {
        MybankConfig.functionVersion = functionVersion;
    }
}