package com.zbkj.service.wangshang.api;

import com.zbkj.service.wangshang.api.internal.mapping.DefaultSignChecker;
import com.zbkj.service.wangshang.api.internal.mapping.DefaultSigner;
import com.zbkj.service.wangshang.api.internal.mapping.SignChecker;
import com.zbkj.service.wangshang.api.internal.mapping.Signer;

public class DefaultMybankClient extends AbstractMybankClient {

    private String privateKey;
    private String mybankPublicKey;
    private String checkPublicKey;
    private Signer signer;
    private SignChecker signChecker;

    /**
     *
     * @param serverUrl 网关请求地址
     * @param privateKey ISV请求报文签名私钥
     * @param mybankPublicKey 网商银行网关公钥
     * @param checkPublicKey 网商银行网关公钥返回报文确认
     */
    public DefaultMybankClient(String serverUrl, String privateKey, String mybankPublicKey, String checkPublicKey) {
        super(serverUrl);
        this.privateKey = privateKey;
        this.signer = new DefaultSigner(privateKey);
        this.mybankPublicKey = mybankPublicKey;
        this.checkPublicKey = checkPublicKey;
        this.signChecker = new DefaultSignChecker(checkPublicKey);
    }

    /**
     *
     * @param serverUrl 网关请求地址
     * @param charset 交互报文字符编码
     * @param privateKey ISV请求报文签名私钥
     * @param mybankPublicKey 网商银行网关公钥
     * @param checkPublicKey 网商银行网关公钥返回报文确认
     */
    public DefaultMybankClient(String serverUrl, String charset, String privateKey, String mybankPublicKey, String checkPublicKey) {
        super(serverUrl, charset);
        this.privateKey = privateKey;
        this.signer = new DefaultSigner(privateKey);
        this.mybankPublicKey = mybankPublicKey;
        this.checkPublicKey = checkPublicKey;
        this.signChecker = new DefaultSignChecker(checkPublicKey);
    }

    /**
     *
     * @param serverUrl 网关请求地址
     * @param charset 交互报文字符编码
     * @param signType 交互报文签名方式
     * @param privateKey ISV请求报文签名私钥
     * @param mybankPublicKey 网商银行网关公钥
     * @param checkPublicKey 网商银行网关公钥返回报文确认
     */
    public DefaultMybankClient(String serverUrl, String charset, String signType, String privateKey, String mybankPublicKey, String checkPublicKey) {
        super(serverUrl, charset, signType);
        this.privateKey = privateKey;
        this.signer = new DefaultSigner(privateKey);
        this.mybankPublicKey = mybankPublicKey;
        this.checkPublicKey = checkPublicKey;
        this.signChecker = new DefaultSignChecker(checkPublicKey);
    }

    /**
     *
     * @param serverUrl 网关请求地址
     * @param format 交互报文格式
     * @param charset 交互报文字符编码
     * @param signType 交互报文签名方式
     * @param privateKey ISV请求报文签名私钥
     * @param mybankPublicKey 网商银行网关公钥
     * @param checkPublicKey 网商银行网关公钥返回报文确认
     */
    public DefaultMybankClient(String serverUrl, String format, String charset, String signType, String privateKey, String mybankPublicKey, String checkPublicKey) {
        super(serverUrl, format, charset, signType);
        this.privateKey = privateKey;
        this.signer = new DefaultSigner(privateKey);
        this.mybankPublicKey = mybankPublicKey;
        this.checkPublicKey = checkPublicKey;
        this.signChecker = new DefaultSignChecker(checkPublicKey);
    }

    @Override
    public Signer getSigner() { return signer; }

    @Override
    public SignChecker getSignChecker() { return signChecker; }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
        if (this.signer == null) {
            this.signer = new DefaultSigner(privateKey);
        }
    }

    public void setMybankPublicKey(String mybankPublicKey) {
        this.mybankPublicKey = mybankPublicKey;
        if (this.signChecker == null) {
            this.signChecker = new DefaultSignChecker(mybankPublicKey);
        }
    }
    public void setCheckPublicKey(String checkPublicKey) {
        this.checkPublicKey = checkPublicKey;
        if (this.signChecker == null) {
            this.signChecker = new DefaultSignChecker(checkPublicKey);
        }
    }

    public static Builder builder(String serverUrl, String privateKey, String mybankPublicKey, String checkPublicKey) {
        return new Builder(serverUrl, privateKey, mybankPublicKey, checkPublicKey);
    }

    public static class Builder {
        private DefaultMybankClient client;

        Builder(String serverUrl, String privateKey, String mybankPublicKey, String checkPublicKey) {
            client = new DefaultMybankClient(serverUrl, privateKey, mybankPublicKey, checkPublicKey);
        }

        public DefaultMybankClient build() {
            return client;
        }

        public Builder format(String format) {
            client.setFormat(format);
            return this;
        }

        public Builder signType(String signType) {
            client.setSignType(signType);
            return this;
        }

        public Builder charset(String charset) {
            client.setCharset(charset);
            return this;
        }

        public Builder connectTimeout(int connectTimeout) {
            client.setConnectTimeout(connectTimeout);
            return this;
        }

        public Builder readTimeout(int readTimeout) {
            client.setReadTimeout(readTimeout);
            return this;
        }
    }
}