package com.zbkj.service.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.model.bcx.BcxChannel;
import com.zbkj.common.model.user.User;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.BcxChannelSearchRequest;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.service.dao.BcxChannelDao;
import com.zbkj.service.service.BcxChannelService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;

/**
 * description: 渠道表 服务实现类
 * author : linchunpeng
 * date : 2023/8/3
 */
@Service
public class BcxChannelServiceImpl extends ServiceImpl<BcxChannelDao, BcxChannel> implements BcxChannelService {
    
    @Resource
    private BcxChannelDao dao;

   /**
    * description：查询渠道商列表
    * author：linchunpeng
    * date：2024/5/13
    */
    @Override
    public PageInfo<BcxChannel> getPage(BcxChannelSearchRequest request, PageParamRequest pageParamRequest) {
        Page<User> userPage = PageHelper.startPage(pageParamRequest.getPage(), pageParamRequest.getLimit());
        Date now = new Date();
        LambdaQueryWrapper<BcxChannel> lqw = new LambdaQueryWrapper<>();
        lqw.select(BcxChannel::getId, BcxChannel::getBcxId, BcxChannel::getName, BcxChannel::getCooperationStartTime, BcxChannel::getCooperationEndTime);
        lqw.le(BcxChannel::getCooperationStartTime, now);
        lqw.ge(BcxChannel::getCooperationEndTime, now);
        if (StrUtil.isNotBlank(request.getChannelName())) {
            lqw.like(BcxChannel::getName, request.getChannelName());
        }
        List<BcxChannel> list = dao.selectList(lqw);
        return CommonPage.copyPageInfo(userPage, list);
    }
    
}