package com.zbkj.service.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.zbkj.common.model.order.RefundOrderInfo;
import com.zbkj.common.model.order.VirtualOrder;
import com.zbkj.common.model.user.User;
import com.zbkj.common.request.CreateOrderRequest;
import com.zbkj.common.response.OrderNoResponse;
import com.zbkj.common.response.VirtualOrderResponse;
import com.zbkj.common.vo.MyRecord;
import com.zbkj.common.vo.PreOrderInfoVo;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * <b> VirtualOrderService </b>
 * @author ZXF
 * @create 2025/08/26 0026 14:27
 * @version
 * @注意事项 </b>
 */
public interface VirtualOrderService extends IService<VirtualOrder> {

    /**
     * 根据虚拟单号获取详情
     * @param virtualOrderNo 虚拟单号
     * @return VirtualOrder
     */
    VirtualOrder getByVirtualOrderNo(String virtualOrderNo);

    VirtualOrderResponse getVirtualOrderByVirtualOrderNo(String virtualOrderNo);

    List<VirtualOrderResponse> queryVirtualOrderList(Map<String, Object> queryParam);

    List<VirtualOrderResponse> queryExistAvailableNumByUid(Integer uid);

    int countAvailableNumByUid(Integer uid);


    /**
     * 创建虚拟订单
     * @param orderRequest 下单请求对象
     * @param orderInfoVo 预下单缓存对象
     * @param skuRecordList 校验库存
     * @param user 用户信息
     * @return
     */
    OrderNoResponse createOrder(CreateOrderRequest orderRequest, PreOrderInfoVo orderInfoVo, List<MyRecord> skuRecordList, User user);

    boolean virtualOrderPay(VirtualOrder virtualOrder,String uniId);

    boolean changeNumByVirtualOrderMap(Map<String, Long> virtualOrderMap, User user);

    boolean dealNumByVirtualOrderMap(Map<String, Long> virtualOrderMap, User user);
}