package com.zbkj.service.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.model.bcx.BcxPerformanceReport;
import com.zbkj.common.model.bcx.BcxSettle;
import com.zbkj.common.model.bcx.BcxSettleBill;
import com.zbkj.common.request.BcxDoSettleRequest;
import com.zbkj.common.request.BcxSettleSearchRequest;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.response.*;

import java.text.ParseException;
import java.util.Date;

/**
 * description: 结算表 服务接口
 * author : linchunpeng
 * date : 2023/9/1
 */
public interface BcxSettleService extends IService<BcxSettle> {

    /**
     * description：根据id，查询结算单
     * author：linchunpeng
     * date：2023/8/17
     */
    BcxSettleDetailResponse findId(Long id);

    /**
     * description：查询结算单
     * author：linchunpeng
     * date：2023/8/15
     */
    PageInfo<BcxSettleResponse> getPage(BcxSettleSearchRequest request, PageParamRequest pageParamRequest) throws ParseException;

    /**
     * description：结算单统计
     * author：linchunpeng
     * date：2024/3/28
     */
    BcxSettleStatisticsResponse statistics(BcxSettleSearchRequest request) throws ParseException;

    /**
     * description：生成结算单
     * author：linchunpeng
     * date：2023/9/4
     */
    void generateSettle(BcxSettleBill settleBill, Long settleId, Long fxsSettleId, String settleNo, BcxSettleBillInfoResponse bcxSettleBillInfoResponse, Date now);

    /**
     * description：当天最后一个结算单
     * author：linchunpeng
     * date：2023/9/4
     */
    BcxSettle getLastNoSettle();

    /**
     * description：结算单号前缀
     * author：linchunpeng
     * date：2023/9/4
     */
    String getSettleNoPrefix();

    /**
     * description：获取生成结算单数据
     * author：linchunpeng
     * date：2023/8/22
     */
    BcxSettleInfoResponse getSettleInfo(BcxDoSettleRequest request);

    /**
     * description：结算
     * author：linchunpeng
     * date：2023/8/22
     */
    Boolean doSettle(BcxDoSettleRequest request);

    /**
     * description：业绩报表直接转账
     * author：linchunpeng
     * date：2024/5/27
     */
    boolean settleReportWithPurse(BcxPerformanceReport report);

    /**
     * description：业绩报表佣金解冻
     * author：linchunpeng
     * date：2024/5/30
     */
    void unFrozenReportWithPurse(BcxPerformanceReport report);

    /**
     * description：撤销结算单
     * author：linchunpeng
     * date：2023/9/6
     */
    Boolean cancel(Long id);
}