package com.zbkj.service.payments.snapshots;

import com.zbkj.common.dto.HuifuWalletTransferDto;
import com.zbkj.common.model.huifu.HuifuWalletTrade;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="HuifuWalletTrade对象", description="企业钱包账户交易记录")
public class PaymentTradeSnapshot extends HuifuWalletTrade {
    private boolean platformFree;

    private String inAccountUniId;
    private String lockAmount;
    /**
     * 平台费用; 仅platformFree=false的时候有效
     */
    private String platAmount;
    private String platAccountUniId;
    private String sellFeePriority;
    private String comment;

    /**
     * 针对平台费用的快照内容
     */
    private HuifuWalletTransferDto platformTransfer;
}
