package com.zbkj.service.payments.results;

import com.zbkj.bcx.cores.constants.PaymentConstant;
import com.zbkj.service.payments.snapshots.PaymentTradeSnapshot;
import lombok.Getter;

import java.util.Collection;
import java.util.Map;

@Getter
public class PaymentCommandResult {
    private final Map<String, Object> response;
    private final Collection<PaymentTradeSnapshot> paymentTradeSnapshots;
    private final String reqSeqId;
    private final String hfSeqId;

    private final boolean forPlatformFree;

    public PaymentCommandResult(
            Map<String, Object> response,
                                Collection<PaymentTradeSnapshot> paymentTradeSnapshots,boolean forPlatformFree) {
        this.response = response;
        this.paymentTradeSnapshots = paymentTradeSnapshots;
        this.reqSeqId = response.get(PaymentConstant.REQ_SEQ_ID).toString();
        this.hfSeqId = response.get(PaymentConstant.HF_SEQ_ID).toString();
        this.forPlatformFree = forPlatformFree;
    }

    public static PaymentCommandResult create(
            Map<String, Object> response, Collection<PaymentTradeSnapshot> paymentTradeSnapshots,boolean forPlatformFree) {
        return new PaymentCommandResult(
                response, paymentTradeSnapshots,forPlatformFree);
    }
}
