package com.zbkj.service.payments.commands;

import lombok.Getter;

@Getter
public class DonePaymentCommand extends CommandAbstract {
    private final String reqSeqId;
    private final String hfSeqId;
    private final boolean forPlatformFree;

    public DonePaymentCommand(String reqSeqId, String hfSeqId,boolean forPlatformFree) {
        this.reqSeqId = reqSeqId;
        this.hfSeqId = hfSeqId;
        this.forPlatformFree = forPlatformFree;
    }

    public static DonePaymentCommand create(String reqSeqId, String hfSeqId,boolean forPlatformFree) {
        return new DonePaymentCommand(reqSeqId, hfSeqId,forPlatformFree);
    }
}
