package com.zbkj.service.payments.commands;

import cn.hutool.core.util.ObjectUtil;
import com.github.pagehelper.util.StringUtil;
import com.zbkj.common.constants.Constants;
import com.zbkj.common.constants.SmsConstants;
import com.zbkj.common.exception.CrmebWalletException;
import com.zbkj.common.utils.RedisUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 拷贝来自com.zbkj.common.dto.HuifuWalletTransferDto
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="HuifuWalletTransferDto", description="商户转账")
public class CreateTransferCommand extends CommandAbstract{
    private String accountStatus;

    @ApiModelProperty(value = "出账方")
    private String outId;

    @ApiModelProperty(value = "入账方")
    private String inId;
    @ApiModelProperty(value = "交易流水号")
    private String reqSeqId;
    @ApiModelProperty(value = "汇付全局流水号")
    private String hfqSeqId;

    @ApiModelProperty(value = "业务交易流水号;比如: 订单号; 同一笔交易; 这个值必须幂等不变")
    private String businessPartnerSeq;
    @ApiModelProperty(value = "业务编码")
    private String businessCode;

    @ApiModelProperty(value = "订单金额")
    private String amount;

    @ApiModelProperty(value = "是否需要验证码")
    private String needActiveCode;

    @ApiModelProperty(value = "验证码")
    private String activeCode;

    @ApiModelProperty(value = "手机号")
    private String contactPhone;

    @ApiModelProperty(value = "备注")
    private String comment;

    @ApiModelProperty(value = "划账金额")
    private String lastschriftAmount;

    @ApiModelProperty(value = "批次号")
    private String batchNo;

    @ApiModelProperty(value = "批次名称")
    private String batchName;

    @ApiModelProperty(value = "开始时间")
    private String startTime;

    @ApiModelProperty(value = "结束时间")
    private String endTime;

    @ApiModelProperty(value = "商品名称")
    private String goodsName;

    @ApiModelProperty(value = "商品数量")
    private String goodsNumber;
    @ApiModelProperty(value = "商品单位")
    private String goodsUnit;
    @ApiModelProperty(value = "交易类型：04冻结，05解冻")
    private String tradeType;
    @ApiModelProperty(value = "销售分账优先级 0-平台 1-商户")
    private Integer sellFeePriority;
    @ApiModelProperty(value = "平台分账金额")
    private String platAmount;
    @ApiModelProperty(value = "交易通道")
    private String payChannel;

    public void validate(RedisUtil redisUtil) {
        if (StringUtil.isEmpty(this.getAmount())) {
            throw new CrmebWalletException("订单金额不能为空");
        }
        if (this.getSellFeePriority() == null) {
            throw new CrmebWalletException("销售分账优先级不能为空");
        }
        if (StringUtil.isEmpty(this.getPlatAmount())) {
            throw new CrmebWalletException("平台分账金额不能为空");
        }
        if (StringUtil.isEmpty(this.getBusinessCode())) {
            throw new CrmebWalletException("业务编码不能为空");
        }
        if (StringUtil.isEmpty(this.getBusinessPartnerSeq())) {
            throw new CrmebWalletException("业务交易流水号不能为空");
        }
        if (StringUtil.isEmpty(this.getGoodsName())) {
            throw new CrmebWalletException("订单商品名称不能为空");
        }
        if (StringUtil.isEmpty(this.getGoodsNumber())) {
            throw new CrmebWalletException("订单商品数量不能为空");
        }
        if (StringUtil.isEmpty(this.getGoodsUnit())) {
            throw new CrmebWalletException("订单商品单位不能为空");
        }
        if (StringUtil.isEmpty(this.getNeedActiveCode())) {
            throw new CrmebWalletException("是否需要验证码不能为空");
        }

        if (Constants.Y.equals(this.getNeedActiveCode())) {
            if (StringUtil.isEmpty(this.getContactPhone())) {
                throw new CrmebWalletException("手机号不能为空");
            }
            if (StringUtil.isEmpty(this.getActiveCode())) {
                throw new CrmebWalletException("短信验证码不能为空");
            }

            checkValidateCode(redisUtil, this.getContactPhone(),this.getActiveCode());
        }
    }

    private void checkValidateCode(RedisUtil redisUtil,String phone, String code) throws CrmebWalletException {
        Object validateCode = redisUtil.get(SmsConstants.SMS_VALIDATE_PHONE + phone);
        if (ObjectUtil.isNull(validateCode)) {
            throw new CrmebWalletException("验证码已过期");
        }
        if (!validateCode.toString().equals(code)) {
            throw new CrmebWalletException("验证码错误");
        }
        //删除验证码
        redisUtil.delete(SmsConstants.SMS_VALIDATE_PHONE + phone);
    }
}
